/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.rest;

import com.atlassian.jira.collector.plugin.components.TriggerConfigurationJSONCache;
import com.atlassian.jira.collector.plugin.rest.model.TriggerConfiguration;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.sun.jersey.api.json.JSONWithPadding;
import java.util.Calendar;
import javax.lang.model.SourceVersion;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="configuration")
@AnonymousAllowed
public class ConfigurationResource {
    private static final int ONE_HOUR = 3600;
    private final TriggerConfigurationJSONCache collectorTriggerConfigurationCache;

    public ConfigurationResource(TriggerConfigurationJSONCache collectorTriggerConfigurationCache) {
        this.collectorTriggerConfigurationCache = collectorTriggerConfigurationCache;
    }

    @GET
    @Path(value="trigger/{collectorId}")
    @Produces(value={"application/x-javascript"})
    public Response getTriggerConfiguration(@PathParam(value="collectorId") String collectorId, @QueryParam(value="callback") @DefaultValue(value="fn") String callback) {
        if (!SourceVersion.isIdentifier(callback)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Callback must be a valid javascript function identifier").build();
        }
        TriggerConfiguration triggerConfiguration = this.collectorTriggerConfigurationCache.getTriggerConfiguration(collectorId);
        if (triggerConfiguration == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.NO_CACHE).build());
        }
        javax.ws.rs.core.CacheControl cacheControl = new javax.ws.rs.core.CacheControl();
        cacheControl.setMaxAge(3600);
        Calendar c = Calendar.getInstance();
        c.add(13, 3600);
        return Response.ok((Object)new JSONWithPadding((Object)triggerConfiguration, callback)).expires(c.getTime()).cacheControl(cacheControl).build();
    }
}

