/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.rest;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.collector.plugin.components.Collector;
import com.atlassian.jira.collector.plugin.components.CollectorService;
import com.atlassian.jira.collector.plugin.components.ErrorLog;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="collector")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CollectorResource {
    private final CollectorService collectorService;
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectService projectService;
    private final ErrorLog errorLog;
    private final PermissionManager permissionManager;

    public CollectorResource(CollectorService collectorService, JiraAuthenticationContext authenticationContext, ProjectService projectService, ErrorLog errorLog, PermissionManager permissionManager) {
        this.collectorService = collectorService;
        this.authenticationContext = authenticationContext;
        this.projectService = projectService;
        this.errorLog = errorLog;
        this.permissionManager = permissionManager;
    }

    @POST
    @Path(value="{collectorId}/status")
    public Response enableCollector(@PathParam(value="collectorId") String collectorId) {
        Collector collector = this.findCollectorById(collectorId);
        Project project = this.findProjectById(collector.getProjectId());
        ServiceOutcome<Boolean> serviceOutcome = this.collectorService.enableCollector(this.authenticationContext.getLoggedInUser(), project, collector.getId());
        return serviceOutcome.isValid() ? Response.ok().cacheControl(CacheControl.NO_CACHE).build() : Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @DELETE
    @Path(value="{collectorId}/status")
    public Response disableCollector(@PathParam(value="collectorId") String collectorId) {
        Collector collector = this.findCollectorById(collectorId);
        Project project = this.findProjectById(collector.getProjectId());
        ServiceOutcome<Boolean> serviceOutcome = this.collectorService.disableCollector(this.authenticationContext.getLoggedInUser(), project, collector.getId());
        return serviceOutcome.isValid() ? Response.ok().cacheControl(CacheControl.NO_CACHE).build() : Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @DELETE
    @Path(value="{collectorId}")
    public Response deleteCollector(@PathParam(value="collectorId") String collectorId) {
        Collector collector = this.findCollectorById(collectorId);
        Project project = this.findProjectById(collector.getProjectId());
        ServiceOutcome<Collector> validateDelete = this.collectorService.validateDeleteCollector(this.authenticationContext.getLoggedInUser(), project, collector.getId());
        if (validateDelete.isValid()) {
            this.collectorService.deleteCollector(this.authenticationContext.getLoggedInUser(), validateDelete);
            return Response.ok().cacheControl(CacheControl.NO_CACHE).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)validateDelete.getErrorCollection().getErrorMessages()).cacheControl(CacheControl.NO_CACHE).build();
    }

    @DELETE
    @Path(value="{projectKey}/errors")
    public Response clearErrors(@PathParam(value="projectKey") String projectKey) {
        Project project = this.findProjectByKey(projectKey);
        if (!this.hasProjectAdminPermission(project)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).cacheControl(CacheControl.NO_CACHE).build();
        }
        this.errorLog.clearErrors(project);
        return Response.ok().cacheControl(CacheControl.NO_CACHE).build();
    }

    private boolean hasProjectAdminPermission(Project project) {
        return this.permissionManager.hasPermission(23, project, this.authenticationContext.getLoggedInUser()) || this.permissionManager.hasPermission(0, this.authenticationContext.getLoggedInUser());
    }

    @Nonnull
    private Project findProjectByKey(String projectKey) throws WebApplicationException {
        ProjectService.GetProjectResult outcome = this.projectService.getProjectByKeyForAction(this.authenticationContext.getLoggedInUser(), projectKey, ProjectAction.EDIT_PROJECT_CONFIG);
        if (!outcome.isValid() || outcome.getProject() == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).cacheControl(CacheControl.NO_CACHE).build());
        }
        return outcome.getProject();
    }

    @Nonnull
    private Project findProjectById(Long projectId) throws WebApplicationException {
        ProjectService.GetProjectResult outcome = this.projectService.getProjectByIdForAction(this.authenticationContext.getLoggedInUser(), projectId, ProjectAction.EDIT_PROJECT_CONFIG);
        if (!outcome.isValid() || outcome.getProject() == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).cacheControl(CacheControl.NO_CACHE).build());
        }
        return outcome.getProject();
    }

    @Nonnull
    private Collector findCollectorById(String collectorId) throws WebApplicationException {
        ServiceOutcome<Collector> outcome = this.collectorService.getCollector(collectorId);
        if (!outcome.isValid() || outcome.getReturnedValue() == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.NO_CACHE).build());
        }
        return (Collector)outcome.getReturnedValue();
    }
}

