/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.components.fieldchecker;

import com.atlassian.jira.collector.plugin.components.Collector;
import com.atlassian.jira.collector.plugin.components.fieldchecker.FieldConfiguration;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MissingFieldsChecker {
    private final FieldLayoutManager fieldLayoutManager;
    private final List<FieldConfiguration> fieldConfigurations;

    @Autowired
    public MissingFieldsChecker(FieldLayoutManager fieldLayoutManager, List<FieldConfiguration> fieldConfigurations) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.fieldConfigurations = fieldConfigurations;
    }

    public List<Collector> getMisconfiguredCollectors(List<Collector> collectors, final Project project) {
        return Lists.newArrayList(Iterables.filter(collectors, new Predicate<Collector>(){

            @Override
            public boolean apply(Collector collector) {
                return MissingFieldsChecker.this.isUsedFieldMissing(collector, project);
            }
        }));
    }

    public Map<String, List<String>> getIssueTypeToMissingFieldsMapping(Project project) {
        HashMap<String, List<String>> missingFieldsMap = Maps.newHashMap();
        for (IssueType issueType : project.getIssueTypes()) {
            ArrayList<String> missingFields = Lists.newArrayList();
            FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(project, issueType.getId());
            for (FieldConfiguration fieldToCheck : this.fieldConfigurations) {
                if (!fieldLayout.isFieldHidden(fieldToCheck.getFieldName())) continue;
                missingFields.add(fieldToCheck.getFieldName());
            }
            missingFieldsMap.put(issueType.getId(), missingFields);
        }
        return missingFieldsMap;
    }

    private boolean isUsedFieldMissing(Collector collector, Project project) {
        FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(project, collector.getIssueTypeId().toString());
        for (FieldConfiguration fieldConfiguration : this.fieldConfigurations) {
            boolean isFieldHidden = fieldLayout.isFieldHidden(fieldConfiguration.getFieldName());
            if (!isFieldHidden || !fieldConfiguration.isUsed(collector)) continue;
            return true;
        }
        return false;
    }
}

