/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.components;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.collector.plugin.components.Collector;
import com.atlassian.jira.collector.plugin.components.CollectorStore;
import com.atlassian.jira.collector.plugin.components.TriggerConfigurationJSONCache;
import com.atlassian.jira.collector.plugin.rest.model.TriggerConfiguration;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TriggerConfigurationJSONCacheImpl
implements TriggerConfigurationJSONCache,
DisposableBean,
InitializingBean {
    public static final TriggerConfiguration NONEXISTENT_TRIGGER_CONFIGURATION = new TriggerConfiguration();
    private final EventPublisher eventPublisher;
    private final LoadingCache<String, TriggerConfiguration> cache;

    @Autowired
    public TriggerConfigurationJSONCacheImpl(final CollectorStore collectorStore, EventPublisher eventPublisher) {
        this(eventPublisher, CacheBuilder.newBuilder().maximumSize(2000L).expireAfterWrite(2L, TimeUnit.HOURS).build(new CacheLoader<String, TriggerConfiguration>(){

            @Override
            public TriggerConfiguration load(String collectorId) throws Exception {
                Collector collector = collectorStore.getCollector(collectorId);
                return collector == null ? NONEXISTENT_TRIGGER_CONFIGURATION : new TriggerConfiguration(collector, JiraUrl.constructBaseUrl((HttpServletRequest)ExecutingHttpRequest.get()));
            }
        }));
    }

    TriggerConfigurationJSONCacheImpl(EventPublisher eventPublisher, LoadingCache<String, TriggerConfiguration> loadingCache) {
        this.eventPublisher = eventPublisher;
        this.cache = loadingCache;
    }

    @Override
    public TriggerConfiguration getTriggerConfiguration(String collectorId) {
        if (collectorId == null || collectorId.length() > 8) {
            return null;
        }
        TriggerConfiguration triggerConfiguration = this.cache.getUnchecked(collectorId);
        return triggerConfiguration == NONEXISTENT_TRIGGER_CONFIGURATION ? null : triggerConfiguration;
    }

    @Override
    public void invalidateTriggerConfiguration(String collectorId) {
        this.cache.invalidate(collectorId);
    }

    @Override
    public void invlidateAllTriggerConfigurations() {
        this.cache.invalidateAll();
    }

    @EventListener
    public void onXmlRestoreCompleted(ClearCacheEvent clearCacheEvent) {
        this.invlidateAllTriggerConfigurations();
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }
}

