/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.components;

import com.atlassian.jira.collector.plugin.components.ErrorLog;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ErrorLogImpl
implements ErrorLog {
    private static final Logger log = Logger.getLogger(ErrorLogImpl.class);
    private static final String ERROR_KEY = "errors";
    private final PluginSettingsFactory pluginSettingsFactory;
    private final I18nHelper.BeanFactory beanFactory;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    public static final int MAX_LOGS = 30;

    @Autowired
    public ErrorLogImpl(PluginSettingsFactory pluginSettingsFactory, I18nHelper.BeanFactory beanFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.beanFactory = beanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logError(Project project, String collectorId, String fullName, String email, String sourceUrl, ErrorLog.ErrorType type) {
        PluginSettings settings = this.getPluginSettings(project);
        ErrorLogImpl errorLogImpl = this;
        synchronized (errorLogImpl) {
            String errorString = (String)settings.get(ERROR_KEY);
            try {
                JSONArray errors = StringUtils.isBlank((String)errorString) ? new JSONArray() : new JSONArray(errorString);
                JSONArray splicedErrors = new JSONArray();
                if (errors.length() > 30) {
                    for (int i = 1; i < errors.length(); ++i) {
                        splicedErrors.put(errors.get(i));
                    }
                } else {
                    splicedErrors = errors;
                }
                JSONObject json = new JSONObject();
                json.put("collectorId", (Object)collectorId).put("timestamp", System.currentTimeMillis()).put("fullName", (Object)fullName).put("email", (Object)email).put("sourceUrl", (Object)sourceUrl).put("type", (Object)type.toString());
                splicedErrors.put((Object)json);
                settings.put(ERROR_KEY, (Object)splicedErrors.toString());
            }
            catch (JSONException e) {
                log.error((Object)("Error storing error log for '" + collectorId + "'"), (Throwable)e);
            }
        }
    }

    @Override
    public List<String> getFormattedErrors(Project project, ApplicationUser remoteUser) {
        ArrayList<String> ret = new ArrayList<String>();
        PluginSettings settings = this.getPluginSettings(project);
        String errorString = (String)settings.get(ERROR_KEY);
        if (StringUtils.isBlank((String)errorString)) {
            return ret;
        }
        try {
            I18nHelper i18n = this.beanFactory.getInstance(remoteUser);
            JSONArray errors = new JSONArray(errorString);
            for (int i = 0; i < errors.length(); ++i) {
                JSONObject error = errors.getJSONObject(i);
                ErrorLog.ErrorType type = ErrorLog.ErrorType.valueOf(error.getString("type"));
                String user = i18n.getText("common.words.anonymous");
                if (error.has("fullName") && StringUtils.isNotBlank((String)error.getString("fullName"))) {
                    user = error.getString("fullName");
                    if (error.has("email")) {
                        user = user + " (" + error.getString("email") + ")";
                    }
                }
                String sourceUrl = error.has("sourceUrl") ? error.getString("sourceUrl") : "unknown source";
                ret.add("[" + this.dateFormat.format(new Date(error.getLong("timestamp"))) + "] " + i18n.getText("collector.plugin.error.log." + type.toString(), error.getString("collectorId"), sourceUrl, user));
            }
        }
        catch (JSONException e) {
            log.error((Object)"Error retrieving collector errors!", (Throwable)e);
        }
        Collections.reverse(ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearErrors(Project project) {
        PluginSettings pluginSettings = this.getPluginSettings(project);
        ErrorLogImpl errorLogImpl = this;
        synchronized (errorLogImpl) {
            pluginSettings.remove(ERROR_KEY);
        }
    }

    private PluginSettings getPluginSettings(Project project) {
        return this.pluginSettingsFactory.createSettingsForKey(String.format("%s.%s", ErrorLogImpl.class.getSimpleName(), project == null ? "__GLOBAL__" : project.getKey()));
    }
}

