/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.components;

import com.atlassian.jira.collector.plugin.components.Collector;
import com.atlassian.jira.collector.plugin.components.CollectorStore;
import com.atlassian.jira.collector.plugin.components.IssueCollectorEventDispatcher;
import com.atlassian.jira.collector.plugin.components.TemplateStore;
import com.atlassian.jira.collector.plugin.components.Trigger;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CollectorStoreImpl
implements CollectorStore {
    private static final Logger log = Logger.getLogger(CollectorStoreImpl.class);
    private static final String ARCHIVED_COLLECTORS = "ARCHIVED_COLLECTORS";
    private final PluginSettingsFactory pluginSettingsFactory;
    private final TemplateStore templateStore;
    private final IssueCollectorEventDispatcher eventDispatcher;

    @Autowired
    public CollectorStoreImpl(PluginSettingsFactory pluginSettingsFactory, TemplateStore templateStore, IssueCollectorEventDispatcher eventDispatcher) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.templateStore = templateStore;
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public List<Collector> getCollectors(Long projectId) {
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        List<String> ids = this.getAllCollectorIds(projectId, globalSettings);
        ArrayList<Collector> collectors = new ArrayList<Collector>();
        for (String id : ids) {
            Collector collector = this.getCollector(id);
            if (collector == null) continue;
            collectors.add(collector);
        }
        return collectors;
    }

    @Override
    public Collector getCollector(String collectorId) {
        Trigger.Position position;
        PluginSettings settings = this.pluginSettingsFactory.createSettingsForKey(collectorId);
        Object id = settings.get("collectorId");
        if (id == null) {
            return null;
        }
        try {
            position = Trigger.Position.valueOf((String)settings.get("triggerPosition"));
        }
        catch (IllegalArgumentException e) {
            position = Trigger.Position.INVALID;
        }
        Trigger trigger = new Trigger((String)settings.get("triggerText"), position, (String)settings.get("triggerCustomFunc"));
        return new Collector.Builder().id((String)settings.get("collectorId")).name((String)settings.get("name")).projectId(this.getLongValue(settings, "projectId", collectorId)).issueTypeId(this.getLongValue(settings, "issueTypeId", collectorId)).creator((String)settings.get("creator")).reporter((String)settings.get("reporter")).description((String)settings.get("description")).template(this.templateStore.getTemplate((String)settings.get("templateId"))).enabled(this.getBooleanValue(settings.get("enabled"))).recoredWebInfo(this.getBooleanValue(settings.get("recordWebInfo"))).useCredentials(this.getBooleanValue(settings.get("useCredentials"))).trigger(trigger).customMessage((String)settings.get("customMessage")).customTemplateFields(this.getList((String)settings.get("customTemplateFields"))).customTemplateTitle((String)settings.get("customTemplateTitle")).customTemplateLabels((String)settings.get("customTemplateLabels")).build();
    }

    private boolean getBooleanValue(Object booleanObject) {
        if (booleanObject == null) {
            return false;
        }
        return Boolean.valueOf((String)booleanObject);
    }

    @Override
    public boolean enableCollector(String collectorId) {
        Collector collector = this.getCollector(collectorId);
        if (collector != null) {
            Collector enabledCollector = new Collector.Builder().collector(collector).enabled(true).build();
            this.storeCollector(enabledCollector);
            this.eventDispatcher.collectorEnabled(enabledCollector);
            return true;
        }
        return false;
    }

    @Override
    public boolean disableCollector(String collectorId) {
        Collector collector = this.getCollector(collectorId);
        if (collector != null) {
            Collector disabledCollector = new Collector.Builder().collector(collector).enabled(false).build();
            this.storeCollector(disabledCollector);
            this.eventDispatcher.collectorDisabled(disabledCollector);
            return true;
        }
        return false;
    }

    @Override
    public void deleteCollector(Long projectId, String collectorId) {
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        List<String> allCollectorIds = this.getAllCollectorIds(projectId, globalSettings);
        if (allCollectorIds.contains(collectorId)) {
            Collector deletedCollector = this.getCollector(collectorId);
            if (deletedCollector != null) {
                this.eventDispatcher.collectorDeleted(deletedCollector);
            }
            ArrayList<String> collectorIds = new ArrayList<String>(allCollectorIds);
            collectorIds.remove(collectorId);
            globalSettings.put(this.getProjectSettingsKey(projectId), collectorIds);
        }
        this.removeCollector(collectorId);
        HashMap<String, String> archive = new HashMap<String, String>(this.getArchivedCollectorIds(globalSettings));
        archive.put(collectorId, Long.toString(projectId));
        globalSettings.put(ARCHIVED_COLLECTORS, archive);
    }

    @Override
    public Long getArchivedProjectId(String collectorId) {
        Map<String, String> archivedCollectorIds = this.getArchivedCollectorIds(this.pluginSettingsFactory.createGlobalSettings());
        if (archivedCollectorIds.containsKey(collectorId)) {
            return Long.valueOf(archivedCollectorIds.get(collectorId));
        }
        return null;
    }

    @Override
    public synchronized Collector addCollector(Collector input) {
        String collectorId;
        while (this.getCollector(collectorId = this.generateCollectorId()) != null) {
        }
        Collector collector = new Collector.Builder().collector(input).id(collectorId).build();
        this.storeCollector(collector);
        this.eventDispatcher.collectorCreated(collector);
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        ArrayList<String> allCollectorIds = Lists.newArrayList(this.getAllCollectorIds(input.getProjectId(), globalSettings));
        allCollectorIds.add(collectorId);
        globalSettings.put(this.getProjectSettingsKey(input.getProjectId()), allCollectorIds);
        return this.getCollector(collectorId);
    }

    @Override
    public Collector updateCollector(String collectorId, Collector collectorData) {
        boolean enabled = this.getCollector(collectorId).isEnabled();
        Collector collector = new Collector.Builder().collector(collectorData).id(collectorId).enabled(enabled).build();
        this.storeCollector(collector);
        this.eventDispatcher.collectorEdited(collector);
        return this.getCollector(collectorId);
    }

    private void removeCollector(String collectorId) {
        PluginSettings settings = this.pluginSettingsFactory.createSettingsForKey(collectorId);
        settings.remove("collectorId");
        settings.remove("name");
        settings.remove("projectId");
        settings.remove("issueTypeId");
        settings.remove("description");
        settings.remove("creator");
        settings.remove("reporter");
        settings.remove("enabled");
        settings.remove("recordWebInfo");
        settings.remove("templateId");
        settings.remove("useCredentials");
        settings.remove("triggerText");
        settings.remove("triggerPosition");
        settings.remove("triggerCustomFunc");
        settings.remove("customMessage");
        settings.remove("customTemplateFields");
        settings.remove("customTemplateTitle");
        settings.remove("customTemplateLabels");
    }

    private void storeCollector(Collector input) {
        PluginSettings settings = this.pluginSettingsFactory.createSettingsForKey(input.getId());
        settings.put("collectorId", (Object)input.getId());
        settings.put("name", (Object)input.getName());
        settings.put("projectId", (Object)input.getProjectId().toString());
        settings.put("issueTypeId", (Object)input.getIssueTypeId().toString());
        settings.put("creator", (Object)input.getCreator());
        settings.put("reporter", (Object)input.getReporter());
        settings.put("description", (Object)input.getDescription());
        settings.put("templateId", (Object)input.getTemplate().getId());
        settings.put("enabled", (Object)Boolean.valueOf(input.isEnabled()).toString());
        settings.put("recordWebInfo", (Object)Boolean.valueOf(input.isRecordWebInfo()).toString());
        settings.put("useCredentials", (Object)Boolean.valueOf(input.isUseCredentials()).toString());
        settings.put("triggerText", (Object)input.getTrigger().getText());
        settings.put("triggerPosition", (Object)input.getTrigger().getPosition().toString());
        settings.put("triggerCustomFunc", (Object)input.getTrigger().getCustomFunction());
        settings.put("customMessage", (Object)input.getCustomMessage());
        settings.put("customTemplateFields", (Object)this.formatList(input.getCustomTemplateFields()));
        settings.put("customTemplateTitle", (Object)input.getCustomTemplateTitle());
        settings.put("customTemplateLabels", (Object)input.getCustomTemplateLabels());
    }

    private List<String> getList(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            return Arrays.asList(value.split(","));
        }
        return Collections.emptyList();
    }

    private String formatList(List<String> templateFields) {
        StringBuilder ret = new StringBuilder();
        Iterator<String> iterator = templateFields.iterator();
        while (iterator.hasNext()) {
            String next = iterator.next();
            ret.append(next);
            if (!iterator.hasNext()) continue;
            ret.append(",");
        }
        return ret.toString();
    }

    private List<String> getAllCollectorIds(Long projectId, PluginSettings globalSettings) {
        List ids = (List)globalSettings.get(this.getProjectSettingsKey(projectId));
        if (ids == null) {
            return Collections.emptyList();
        }
        return ids;
    }

    private Map<String, String> getArchivedCollectorIds(PluginSettings globalSettings) {
        Map archive = (Map)globalSettings.get(ARCHIVED_COLLECTORS);
        if (archive == null) {
            return Collections.emptyMap();
        }
        return archive;
    }

    private String getProjectSettingsKey(Long projectId) {
        return "COLLECTOR_IDS." + projectId;
    }

    private Long getLongValue(PluginSettings settings, String field, String id) {
        String valueString = (String)settings.get(field);
        try {
            return Long.parseLong(valueString);
        }
        catch (NumberFormatException e) {
            log.error((Object)("Invalid value for collector '" + id + "' field '" + field + "': '" + valueString + "'"));
            return null;
        }
    }

    private String generateCollectorId() {
        return DefaultSecureTokenGenerator.getInstance().generateToken().substring(0, 8);
    }

    static final class Fields {
        static final String COLLECTOR_ID = "collectorId";
        static final String COLLECTOR_NAME = "name";
        static final String PROJECT_ID = "projectId";
        static final String ISSUE_TYPE_ID = "issueTypeId";
        static final String CREATOR = "creator";
        static final String REPORTER = "reporter";
        static final String DESCRIPTION = "description";
        static final String ENABLED = "enabled";
        static final String RECORD_WEB_INFO = "recordWebInfo";
        static final String TEMPLATE_ID = "templateId";
        static final String USE_CREDENTIALS = "useCredentials";
        static final String TRIGGER_TEXT = "triggerText";
        static final String TRIGGER_POSITION = "triggerPosition";
        static final String TRIGGER_CUSTOM_FUNC = "triggerCustomFunc";
        static final String CUSTOM_MESSAGE = "customMessage";
        static final String CUSTOM_TEMPLATE_FIELDS = "customTemplateFields";
        static final String CUSTOM_TEMPLATE_TITLE = "customTemplateTitle";
        static final String CUSTOM_TEMPLATE_LABELS = "customTemplateLabels";

        private Fields() {
        }
    }
}

