/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.components;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.collector.plugin.components.Collector;
import com.atlassian.jira.collector.plugin.components.CollectorFieldValidator;
import com.atlassian.jira.collector.plugin.components.CollectorService;
import com.atlassian.jira.collector.plugin.components.CollectorStore;
import com.atlassian.jira.collector.plugin.components.Template;
import com.atlassian.jira.collector.plugin.components.TemplateStore;
import com.atlassian.jira.collector.plugin.components.Trigger;
import com.atlassian.jira.collector.plugin.components.TriggerConfigurationJSONCache;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={CollectorService.class})
public class CollectorServiceImpl
implements CollectorService {
    private final PermissionManager permissionManager;
    private final I18nHelper.BeanFactory beanFactory;
    private final CollectorStore collectorStore;
    private final ProjectManager projectManager;
    private final UserUtil userUtil;
    private final TemplateStore templateStore;
    private final CollectorFieldValidator collectorFieldValidator;
    private final TriggerConfigurationJSONCache triggerConfigurationJSONCache;

    @Autowired
    public CollectorServiceImpl(PermissionManager permissionManager, I18nHelper.BeanFactory beanFactory, CollectorStore collectorStore, ProjectManager projectManager, UserUtil userUtil, TemplateStore templateStore, CollectorFieldValidator collectorFieldValidator, TriggerConfigurationJSONCache triggerConfigurationJSONCache) {
        this.permissionManager = permissionManager;
        this.beanFactory = beanFactory;
        this.collectorStore = collectorStore;
        this.projectManager = projectManager;
        this.userUtil = userUtil;
        this.templateStore = templateStore;
        this.collectorFieldValidator = collectorFieldValidator;
        this.triggerConfigurationJSONCache = triggerConfigurationJSONCache;
    }

    @Override
    public ServiceOutcome<Collector> getCollector(String collectorId) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        return new ServiceOutcomeImpl((ErrorCollection)errors, (Object)this.collectorStore.getCollector(collectorId));
    }

    @Override
    public ServiceOutcome<Map<Long, List<Collector>>> getCollectorsPerProject(ApplicationUser remoteUser) {
        LinkedHashMap<Long, Object> ret = new LinkedHashMap<Long, Object>();
        for (Project project : this.projectManager.getProjectObjects()) {
            ServiceOutcome<List<Collector>> result = this.getCollectors(remoteUser, project);
            if (!result.isValid() || ((List)result.getReturnedValue()).isEmpty()) continue;
            ret.put(project.getId(), result.getReturnedValue());
        }
        return new ServiceOutcomeImpl((ErrorCollection)new SimpleErrorCollection(), ret);
    }

    @Override
    public ServiceOutcome<List<Collector>> getCollectors(ApplicationUser remoteUser, Project project) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18n = this.beanFactory.getInstance(remoteUser);
        if (!this.hasProjectAdminPermission(project, remoteUser)) {
            errors.addErrorMessage(i18n.getText("collector.plugin.admin.error.view.no.permission"));
            return new ServiceOutcomeImpl((ErrorCollection)errors);
        }
        return new ServiceOutcomeImpl((ErrorCollection)errors, this.collectorStore.getCollectors(project.getId()));
    }

    @Override
    public ServiceOutcome<Boolean> validateCreateCollector(Project project, ApplicationUser user) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18n = this.beanFactory.getInstance(user);
        if (project == null) {
            errors.addErrorMessage(i18n.getText("collector.plugin.admin.error.no.project"));
            return new ServiceOutcomeImpl((ErrorCollection)errors, (Object)false);
        }
        if (!this.hasCreateIssuePermission(project, user) || !this.hasProjectAdminPermission(project, user)) {
            errors.addErrorMessage(i18n.getText("collector.plugin.admin.error.add.no.permission"));
            return new ServiceOutcomeImpl((ErrorCollection)errors, (Object)false);
        }
        return new ServiceOutcomeImpl((ErrorCollection)errors, (Object)true);
    }

    @Override
    public boolean hasViewPermission(ApplicationUser user, Collector collector) {
        Project project = this.projectManager.getProjectObj(collector.getProjectId());
        return project != null && this.hasProjectAdminPermission(project, user);
    }

    @Override
    public ServiceOutcome<Collector> validateCreateCollector(ApplicationUser remoteUser, String name, Long projectId, Long issueTypeId, String reporter, String description, String templateId, boolean recordWebInfo, boolean useCredentials, Trigger trigger, String customMessage, List<String> customTemplateFields, String customTemplateTitle, String customTemplateLabels) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18n = this.beanFactory.getInstance(remoteUser);
        Project project = this.projectManager.getProjectObj(projectId);
        ServiceOutcome<Boolean> initialValidation = this.validateCreateCollector(project, remoteUser);
        if (!initialValidation.isValid()) {
            return new ServiceOutcomeImpl(initialValidation.getErrorCollection());
        }
        Set<String> notAllowedFields = this.collectorFieldValidator.getRequiredInvalidFieldsForIssueType(remoteUser, project, issueTypeId.toString());
        if (!notAllowedFields.isEmpty()) {
            errors.addError("requireInvalidFields", i18n.getText("collector.plugin.admin.error.not.allowed.fields", StringUtils.join(notAllowedFields, (String)", ")));
            return new ServiceOutcomeImpl((ErrorCollection)errors);
        }
        if (StringUtils.isBlank((String)name)) {
            errors.addError("collectorName", i18n.getText("collector.plugin.admin.error.no.name"));
        }
        if (reporter == null || StringUtils.isEmpty((String)reporter)) {
            errors.addError("reporter", i18n.getText("collector.plugin.admin.error.empty.reporter"));
        } else {
            ApplicationUser reporterUser = this.userUtil.getUserObject(reporter);
            if (reporterUser == null) {
                errors.addError("reporter", i18n.getText("collector.plugin.admin.error.no.reporter", reporter));
            } else {
                boolean reporterHasPermissions = this.permissionManager.hasPermission(11, project, remoteUser);
                if (!reporterHasPermissions) {
                    errors.addError("reporter", i18n.getText("collector.plugin.admin.error.invalid.reporter", reporter));
                }
            }
        }
        Template template = this.templateStore.getTemplate(templateId);
        if (template == null) {
            errors.addErrorMessage(i18n.getText("collector.plugin.admin.error.no.template", templateId));
        } else if ("custom".equals(template.getId()) && customTemplateFields.isEmpty()) {
            errors.addErrorMessage(i18n.getText("collector.plugin.admin.error.no.template.fields", templateId));
        }
        if (errors.hasAnyErrors()) {
            return new ServiceOutcomeImpl((ErrorCollection)errors);
        }
        Collector collector = new Collector.Builder().name(name).projectId(projectId).issueTypeId(issueTypeId).creator(remoteUser == null ? null : remoteUser.getName()).reporter(reporter).description(description).template(template).enabled(true).recoredWebInfo(recordWebInfo).useCredentials(useCredentials).trigger(trigger).customMessage(customMessage).customTemplateFields(customTemplateFields).customTemplateTitle(customTemplateTitle).customTemplateLabels(customTemplateLabels).build();
        return new ServiceOutcomeImpl((ErrorCollection)errors, (Object)collector);
    }

    @Override
    public String createCollector(ServiceOutcome<Collector> outcome) {
        Collector collector = this.collectorStore.addCollector((Collector)outcome.getReturnedValue());
        String collectorId = collector.getId();
        this.triggerConfigurationJSONCache.invalidateTriggerConfiguration(collectorId);
        return collectorId;
    }

    @Override
    public void updateCollector(String collectorId, ServiceOutcome<Collector> collectorData) {
        this.triggerConfigurationJSONCache.invalidateTriggerConfiguration(collectorId);
        this.collectorStore.updateCollector(collectorId, (Collector)collectorData.getReturnedValue());
    }

    @Override
    public ServiceOutcome<Boolean> enableCollector(ApplicationUser remoteUser, Project project, String collectorId) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18n = this.beanFactory.getInstance(remoteUser);
        if (!this.hasProjectAdminPermission(project, remoteUser)) {
            errors.addErrorMessage(i18n.getText("collector.plugin.admin.error.view.no.permission"));
            return new ServiceOutcomeImpl((ErrorCollection)errors);
        }
        this.triggerConfigurationJSONCache.invalidateTriggerConfiguration(collectorId);
        return new ServiceOutcomeImpl((ErrorCollection)errors, (Object)this.collectorStore.enableCollector(collectorId));
    }

    @Override
    public ServiceOutcome<Boolean> disableCollector(ApplicationUser remoteUser, Project project, String collectorId) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18n = this.beanFactory.getInstance(remoteUser);
        if (!this.hasProjectAdminPermission(project, remoteUser)) {
            errors.addErrorMessage(i18n.getText("collector.plugin.admin.error.view.no.permission"));
            return new ServiceOutcomeImpl((ErrorCollection)errors);
        }
        this.triggerConfigurationJSONCache.invalidateTriggerConfiguration(collectorId);
        return new ServiceOutcomeImpl((ErrorCollection)errors, (Object)this.collectorStore.disableCollector(collectorId));
    }

    @Override
    public ServiceOutcome<Collector> validateDeleteCollector(ApplicationUser remoteUser, Project project, String collectorId) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18n = this.beanFactory.getInstance(remoteUser);
        if (!this.hasProjectAdminPermission(project, remoteUser)) {
            errors.addErrorMessage(i18n.getText("collector.plugin.admin.error.view.no.permission"));
            return new ServiceOutcomeImpl((ErrorCollection)errors);
        }
        Collector collector = this.collectorStore.getCollector(collectorId);
        return new ServiceOutcomeImpl((ErrorCollection)errors, (Object)collector);
    }

    @Override
    public void deleteCollector(ApplicationUser loggedInUser, ServiceOutcome<Collector> validationResult) {
        Collector collector = (Collector)validationResult.getReturnedValue();
        if (collector == null) {
            throw new IllegalArgumentException("Got emtpy validation result!");
        }
        this.triggerConfigurationJSONCache.invalidateTriggerConfiguration(collector.getId());
        this.collectorStore.deleteCollector(collector.getProjectId(), collector.getId());
    }

    @Override
    public Long getArchivedProjectId(String collectorId) {
        return this.collectorStore.getArchivedProjectId(collectorId);
    }

    private boolean hasProjectAdminPermission(Project project, ApplicationUser user) {
        return this.permissionManager.hasPermission(23, project, user) || this.permissionManager.hasPermission(0, user);
    }

    private boolean hasCreateIssuePermission(Project project, ApplicationUser user) {
        return this.permissionManager.hasPermission(11, project, user);
    }
}

