/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.components;

import com.atlassian.jira.collector.plugin.components.CollectorFieldValidator;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={CollectorFieldValidator.class})
public class CollectorFieldValidatorImpl
implements CollectorFieldValidator {
    private static final Set<String> FIELDS_TO_INCLUDE = ImmutableSet.of("summary", "description", "components", "versions", "environment", "priority", new String[0]);
    private static final Set<String> CUSTOM_FIELDS_TYPES_TO_INCLUDE = ImmutableSet.of("com.atlassian.jira.plugin.system.customfieldtypes:datetime", "com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons", "com.atlassian.jira.plugin.system.customfieldtypes:select", "com.atlassian.jira.plugin.system.customfieldtypes:url", "com.atlassian.jira.plugin.system.customfieldtypes:multiversion", "com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect", new String[]{"com.atlassian.jira.plugin.system.customfieldtypes:version", "com.atlassian.jira.plugin.system.customfieldtypes:textfield", "com.atlassian.jira.plugin.system.customfieldtypes:datepicker", "com.atlassian.jira.plugin.system.customfieldtypes:textarea", "com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes", "com.atlassian.jira.plugin.system.customfieldtypes:multiselect", "com.atlassian.jira.plugin.system.customfieldtypes:float"});
    private static final Set<String> REQUIRED_BY_DEFAULT = ImmutableSet.of("security", "issuetype", "reporter");
    private final CustomFieldManager customFieldManager;
    private final IssueFactory issueFactory;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;

    @Autowired
    public CollectorFieldValidatorImpl(CustomFieldManager customFieldManager, IssueFactory issueFactory, FieldScreenRendererFactory fieldScreenRendererFactory) {
        this.customFieldManager = customFieldManager;
        this.issueFactory = issueFactory;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
    }

    @Override
    public Map<String, Set<String>> getRequiredInvalidFieldsForProject(ApplicationUser loggedUser, Project project) {
        HashMap<String, Set<String>> requiredFileds = Maps.newHashMap();
        for (IssueType issueType : project.getIssueTypes()) {
            requiredFileds.put(issueType.getId(), this.getRequiredInvalidFieldsForIssueType(loggedUser, project, issueType.getId()));
        }
        return requiredFileds;
    }

    @Override
    public Set<String> getRequiredInvalidFieldsForIssueType(ApplicationUser loggedUser, Project project, String issueTypeId) {
        MutableIssue issue = this.issueFactory.getIssue();
        issue.setProjectId(project.getId());
        issue.setIssueTypeId(issueTypeId);
        FieldScreenRenderer fieldScreenRenderer = this.fieldScreenRendererFactory.getFieldScreenRenderer(loggedUser, (Issue)issue, (IssueOperation)IssueOperations.CREATE_ISSUE_OPERATION, false);
        List fieldScreenRenderTabs = fieldScreenRenderer.getFieldScreenRenderTabs();
        Set<String> allowedCustomFieldIds = this.getAllowedCustomFieldIds(project, issue.getIssueTypeObject().getId());
        HashSet<String> notAllowedFields = Sets.newHashSet();
        for (FieldScreenRenderTab fieldScreenRenderTab : fieldScreenRenderTabs) {
            for (FieldScreenRenderLayoutItem fsrli : fieldScreenRenderTab.getFieldScreenRenderLayoutItems()) {
                String fieldId;
                FieldLayoutItem fieldLayoutItem = fsrli.getFieldLayoutItem();
                if (!fieldLayoutItem.isRequired() || this.getDefaultValue(issue, fieldLayoutItem) != null || this.isFieldAllowed(fieldId = fieldLayoutItem.getOrderableField().getId()) || allowedCustomFieldIds.contains(fieldId)) continue;
                notAllowedFields.add(fieldLayoutItem.getOrderableField().getName());
            }
        }
        return notAllowedFields;
    }

    private Object getDefaultValue(MutableIssue issue, FieldLayoutItem fieldLayoutItem) {
        return fieldLayoutItem.getOrderableField().getDefaultValue((Issue)issue);
    }

    @Override
    public boolean isFieldAllowedInCustomCollector(String fieldId) {
        return FIELDS_TO_INCLUDE.contains(fieldId);
    }

    @Override
    public Set<String> getAllowedCustomFieldIds(Project project, String issueType) {
        List customFieldObjects = this.customFieldManager.getCustomFieldObjects(project.getId(), issueType);
        return ImmutableSet.copyOf(Iterables.transform(Iterables.filter(customFieldObjects, new Predicate<CustomField>(){

            @Override
            public boolean apply(CustomField customField) {
                return CUSTOM_FIELDS_TYPES_TO_INCLUDE.contains(customField.getCustomFieldType().getKey());
            }
        }), new Function<CustomField, String>(){

            @Override
            public String apply(CustomField customField) {
                return customField.getId();
            }
        }));
    }

    private boolean isFieldAllowed(String fieldId) {
        return FIELDS_TO_INCLUDE.contains(fieldId) || REQUIRED_BY_DEFAULT.contains(fieldId);
    }
}

