/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nps.plugin;

import com.atlassian.nps.plugin.NpsStatus;
import com.atlassian.nps.plugin.NpsStatusEntity;
import com.atlassian.nps.plugin.utils.UserPermissionsHelper;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/status")
public class NpsStatusResource {
    private final NpsStatus npsStatus;
    private final UserPermissionsHelper userPermissionsHelper;

    public NpsStatusResource(NpsStatus npsStatus, UserPermissionsHelper userPermissionsHelper) {
        this.npsStatus = npsStatus;
        this.userPermissionsHelper = userPermissionsHelper;
    }

    @GET
    @Path(value="/acknowledge")
    @Produces(value={"application/json"})
    public Response isNpsAcknowledged() {
        return Response.ok((Object)this.npsStatus.isNpsAcknowledged()).header("content-type", (Object)"application/json; charset=UTF-8").build();
    }

    @PUT
    @Path(value="/acknowledge")
    public Response setNpsAcknowledged(@Context HttpServletRequest request, NpsStatusEntity in) {
        if (!this.userPermissionsHelper.isRequestUserSystemAdmin(request)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.npsStatus.setNpsAcknowledged(in.isNpsAcknowledged());
        return Response.ok().header("content-type", (Object)"application/json; charset=UTF-8").build();
    }

    @GET
    @Path(value="/enable")
    @Produces(value={"application/json"})
    public Response isNpsEnabled() {
        return Response.ok((Object)this.npsStatus.isNpsEnabled()).header("content-type", (Object)"application/json; charset=UTF-8").build();
    }

    @PUT
    @Path(value="/enable")
    public Response setNpsEnabled(@Context HttpServletRequest request, NpsStatusEntity in) {
        if (!this.userPermissionsHelper.isRequestUserSystemAdmin(request)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.npsStatus.setNpsEnabled(in.isNpsEnabled());
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/enable")
    public Response deleteConfig() {
        this.npsStatus.deleteNpsEnabledProperty();
        return Response.ok().header("content-type", (Object)"application/json; charset=UTF-8").build();
    }
}

