/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nps.plugin;

import com.atlassian.nps.plugin.storage.CommonServerStorageService;
import org.apache.commons.lang.StringUtils;

public class NpsStatus {
    private static final String KEY_PREFIX = "com.atlassian.nps.plugin.status.";
    private final CommonServerStorageService commonServerStorageService;

    public NpsStatus(CommonServerStorageService commonServerStorageService) {
        this.commonServerStorageService = commonServerStorageService;
    }

    public boolean isNpsAcknowledged() {
        String npsAcknowledged = this.commonServerStorageService.getSetting(Key.NPS_ACKNOWLEDGED);
        return StringUtils.isNotEmpty((String)npsAcknowledged) && Boolean.parseBoolean(npsAcknowledged);
    }

    public void setNpsAcknowledged(boolean npsAcknowledged) {
        this.commonServerStorageService.putSetting(Key.NPS_ACKNOWLEDGED, Boolean.toString(npsAcknowledged));
    }

    public boolean isNpsEnabled() {
        String npsEnabled = this.commonServerStorageService.getSetting(Key.NPS_ENABLED);
        return StringUtils.isNotEmpty((String)npsEnabled) && Boolean.parseBoolean(npsEnabled);
    }

    public void setNpsEnabled(boolean npsEnabled) {
        this.commonServerStorageService.putSetting(Key.NPS_ENABLED, Boolean.toString(npsEnabled));
    }

    public void deleteNpsEnabledProperty() {
        this.commonServerStorageService.deleteSetting(Key.NPS_ENABLED);
    }

    public static enum Key {
        NPS_ACKNOWLEDGED("nps_acknowledged"),
        NPS_ENABLED("nps_enabled");

        private final String key;

        private Key(String suffix) {
            this.key = NpsStatus.KEY_PREFIX + suffix;
        }

        public String getKey() {
            return this.key;
        }
    }
}

