/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nps.plugin;

import com.atlassian.nps.plugin.NpsConfig;
import com.atlassian.nps.plugin.NpsConfigEntity;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/config")
@Produces(value={"application/json;charset=UTF-8"})
public class NpsConfigResource {
    private final NpsConfig npsConfig;

    public NpsConfigResource(NpsConfig npsConfig) {
        this.npsConfig = npsConfig;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getAllConfig() {
        return Response.ok(this.npsConfig.getAllConfig()).build();
    }

    @PUT
    public Response setConfig(NpsConfigEntity nce) {
        this.npsConfig.setDismissedCount(nce.getDismissedCount());
        if (nce.getForceUpdate() != null && nce.getForceUpdate().booleanValue()) {
            this.npsConfig.setOptedOutForTest(nce.getOptedOut());
            this.npsConfig.setNextSurveyDateForTest(nce.getNextSurveyDate());
        } else {
            this.npsConfig.setOptedOut(nce.getOptedOut());
            this.npsConfig.setNextSurveyDate(nce.getNextSurveyDate());
        }
        return Response.ok().build();
    }

    @DELETE
    public Response deleteConfig() {
        this.npsConfig.deleteAllConfig();
        return Response.ok().build();
    }

    @Path(value="/nextSurveyDate")
    @POST
    public Response setNextSurveyDate() {
        this.npsConfig.generateAndSetSurveyDate();
        return Response.ok((Object)Long.valueOf(this.npsConfig.getNextSurveyDate()).toString()).build();
    }
}

