/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.workflow;

import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.order.OrderFactory;
import com.atlassian.jira.projectconfig.workflow.DraftWorkflowSchemeEditor;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultWorkflowSchemeEditor
implements DraftWorkflowSchemeEditor {
    private final OrderFactory orderFactory;

    @Autowired
    public DefaultWorkflowSchemeEditor(OrderFactory orderFactory) {
        this.orderFactory = orderFactory;
    }

    @Override
    public DraftWorkflowScheme assign(DraftWorkflowScheme workflowScheme, Iterable<String> issueTypesToAssign, String newWorkflow, Project project) {
        HashSet types = Sets.newHashSet(issueTypesToAssign);
        HashMultimap invertedWorkflow = HashMultimap.create();
        for (IssueType issueType : project.getIssueTypes()) {
            String issueTypeId = issueType.getId();
            if (types.contains(issueTypeId)) {
                invertedWorkflow.put((Object)newWorkflow, (Object)issueTypeId);
                continue;
            }
            String actualWorkflow = workflowScheme.getActualWorkflow(issueTypeId);
            invertedWorkflow.put((Object)actualWorkflow, (Object)issueTypeId);
        }
        String defaultWorkflow = workflowScheme.getActualDefaultWorkflow();
        if (!invertedWorkflow.containsKey((Object)defaultWorkflow)) {
            Ordering ordering = Ordering.from(this.orderFactory.createStringComparator());
            defaultWorkflow = (String)ordering.min((Iterable)invertedWorkflow.keySet());
        }
        invertedWorkflow.removeAll((Object)defaultWorkflow);
        DraftWorkflowScheme.Builder builder = (DraftWorkflowScheme.Builder)((DraftWorkflowScheme.Builder)workflowScheme.builder().clearMappings()).setDefaultWorkflow(defaultWorkflow);
        for (Map.Entry mapping : invertedWorkflow.entries()) {
            builder.setMapping((String)mapping.getValue(), (String)mapping.getKey());
        }
        return builder.build();
    }

    @Override
    public DraftWorkflowScheme delete(DraftWorkflowScheme workflowScheme, String deleteWorkflow, Project project) {
        HashMultimap invertedWorkflow = HashMultimap.create();
        for (IssueType issueType : project.getIssueTypes()) {
            String issueTypeId = issueType.getId();
            String actualWorkflow = workflowScheme.getActualWorkflow(issueTypeId);
            invertedWorkflow.put((Object)actualWorkflow, (Object)issueTypeId);
        }
        invertedWorkflow.removeAll((Object)deleteWorkflow);
        if (invertedWorkflow.isEmpty()) {
            return ((DraftWorkflowScheme.Builder)workflowScheme.builder().setMappings(Collections.emptyMap())).build();
        }
        String defaultWorkflow = workflowScheme.getActualDefaultWorkflow();
        if (defaultWorkflow.equals(deleteWorkflow)) {
            Ordering ordering = Ordering.from(this.orderFactory.createStringComparator());
            defaultWorkflow = (String)ordering.min((Iterable)invertedWorkflow.keySet());
        }
        invertedWorkflow.removeAll((Object)defaultWorkflow);
        DraftWorkflowScheme.Builder builder = (DraftWorkflowScheme.Builder)((DraftWorkflowScheme.Builder)workflowScheme.builder().clearMappings()).setDefaultWorkflow(defaultWorkflow);
        for (Map.Entry mapping : invertedWorkflow.entries()) {
            builder.setMapping((String)mapping.getValue(), (String)mapping.getKey());
        }
        return builder.build();
    }
}

