/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.workflow;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.workflow.WorkflowSchemeService;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.workflow.ProjectConfigWorkflowDispatcher;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.jira.workflow.migration.AssignableWorkflowSchemeMigrationHelper;
import com.atlassian.jira.workflow.migration.MigrationHelperFactory;
import java.text.Normalizer;
import java.util.Collections;
import java.util.concurrent.RejectedExecutionException;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultProjectConfigWorkflowDispatcher
implements ProjectConfigWorkflowDispatcher {
    private static final Pattern DIACRITICAL_MARKS = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    private static final int MAX_WORKFLOW_NAME_LENGTH = 255;
    private static final int MAX_WORKFLOW_SCHEME_NAME_LENGTH = 255;
    private final WorkflowSchemeService workflowSchemeService;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final ProjectService projectService;
    private final JiraAuthenticationContext authCtx;
    private final PermissionManager permissionManager;
    private final WorkflowService workflowService;
    private final MigrationHelperFactory migrationFactory;

    @Autowired
    public DefaultProjectConfigWorkflowDispatcher(WorkflowSchemeService workflowSchemeService, WorkflowSchemeManager workflowSchemeManager, ProjectService projectService, JiraAuthenticationContext authCtx, PermissionManager permissionManager, WorkflowService workflowService, MigrationHelperFactory migrationFactory) {
        this.workflowSchemeService = workflowSchemeService;
        this.workflowSchemeManager = workflowSchemeManager;
        this.projectService = projectService;
        this.authCtx = authCtx;
        this.permissionManager = permissionManager;
        this.workflowService = workflowService;
        this.migrationFactory = migrationFactory;
    }

    @Override
    public ServiceOutcome<Pair<String, Long>> editWorkflow(long projectId) {
        ApplicationUser user = this.authCtx.getLoggedInUser();
        if (!this.permissionManager.hasPermission(0, user)) {
            return this.error(ErrorCollection.Reason.FORBIDDEN, "admin.project.workflow.no.edit.permission");
        }
        Project project = this.project(projectId, user);
        if (project == null) {
            return this.error(ErrorCollection.Reason.NOT_FOUND, "admin.project.project.no.edit.permission");
        }
        if (!this.workflowSchemeService.isUsingDefaultScheme(project)) {
            return this.error(ErrorCollection.Reason.VALIDATION_FAILED, "admin.project.workflow.not.default.scheme");
        }
        ServiceOutcome<String> copyWfOutcome = this.copySystemWorkflow(project);
        if (!copyWfOutcome.isValid()) {
            return DefaultProjectConfigWorkflowDispatcher.error(copyWfOutcome);
        }
        ServiceOutcome<Long> createSchemeeOutcome = this.createNewSchemeFromWorkflow((String)copyWfOutcome.getReturnedValue(), project);
        if (!createSchemeeOutcome.isValid()) {
            return DefaultProjectConfigWorkflowDispatcher.error(createSchemeeOutcome);
        }
        ServiceOutcome<Long> migrateOutcome = this.migrateWorkflow(project, (Long)createSchemeeOutcome.getReturnedValue());
        if (migrateOutcome.isValid()) {
            return ServiceOutcomeImpl.ok((Object)Pair.nicePairOf((Object)copyWfOutcome.getReturnedValue(), (Object)migrateOutcome.getReturnedValue()));
        }
        return DefaultProjectConfigWorkflowDispatcher.error(migrateOutcome);
    }

    @Override
    public ServiceOutcome<ProjectConfigWorkflowDispatcher.EditSchemeResult> editScheme(String projectKey) {
        ServiceOutcome draftOutcome;
        Assertions.notBlank((String)"projectKey", (String)projectKey);
        ApplicationUser loggedInUser = this.authCtx.getLoggedInUser();
        if (!this.permissionManager.hasPermission(0, loggedInUser)) {
            return this.error(ErrorCollection.Reason.FORBIDDEN, "admin.project.scheme.no.edit.permission");
        }
        Project project = this.project(projectKey, loggedInUser);
        if (project == null) {
            return this.error(ErrorCollection.Reason.NOT_FOUND, "admin.project.project.no.edit.permission");
        }
        ServiceOutcome currentOutcome = this.workflowSchemeService.getSchemeForProject(loggedInUser, project);
        if (!currentOutcome.isValid()) {
            return DefaultProjectConfigWorkflowDispatcher.error(currentOutcome);
        }
        AssignableWorkflowScheme currentScheme = (AssignableWorkflowScheme)currentOutcome.getReturnedValue();
        if (currentScheme.isDefault()) {
            ServiceOutcome<Long> createSchemeOutcome = this.createNewSchemeFromWorkflow("jira", project);
            if (!createSchemeOutcome.isValid()) {
                return ServiceOutcomeImpl.from((ErrorCollection)createSchemeOutcome.getErrorCollection(), null);
            }
            try {
                AssignableWorkflowScheme scheme = this.workflowSchemeManager.getWorkflowSchemeObj(((Long)createSchemeOutcome.getReturnedValue()).longValue());
                AssignableWorkflowSchemeMigrationHelper migrationHelper = this.migrationFactory.createMigrationHelper(project, scheme);
                migrationHelper.associateProjectAndWorkflowScheme();
            }
            catch (GenericEntityException e) {
                throw new DataAccessException((Throwable)e);
            }
            currentOutcome = this.workflowSchemeService.getSchemeForProject(loggedInUser, project);
            if (!currentOutcome.isValid()) {
                return DefaultProjectConfigWorkflowDispatcher.error(currentOutcome);
            }
        }
        if (!(draftOutcome = this.workflowSchemeService.getDraftWorkflowScheme(loggedInUser, currentScheme = (AssignableWorkflowScheme)currentOutcome.getReturnedValue())).isValid()) {
            return DefaultProjectConfigWorkflowDispatcher.error(draftOutcome);
        }
        if (draftOutcome.getReturnedValue() == null && !(draftOutcome = this.workflowSchemeService.createDraft(loggedInUser, currentScheme.getId().longValue())).isValid()) {
            return DefaultProjectConfigWorkflowDispatcher.error(draftOutcome);
        }
        return ServiceOutcomeImpl.ok((Object)new ProjectConfigWorkflowDispatcher.EditSchemeResult(currentScheme, (DraftWorkflowScheme)draftOutcome.getReturnedValue(), project));
    }

    ServiceOutcome<Long> migrateWorkflow(Project project, Long targetSchemeId) {
        try {
            AssignableWorkflowScheme scheme = this.workflowSchemeManager.getWorkflowSchemeObj(targetSchemeId.longValue());
            AssignableWorkflowSchemeMigrationHelper migrationHelper = this.migrationFactory.createMigrationHelper(project, scheme);
            if (!migrationHelper.doQuickMigrate()) {
                TaskDescriptor returnedValue = migrationHelper.migrateAsync();
                return ServiceOutcomeImpl.ok((Object)returnedValue.getTaskId());
            }
            return ServiceOutcomeImpl.ok(null);
        }
        catch (GenericEntityException e) {
            return this.error(ErrorCollection.Reason.SERVER_ERROR, "admin.project.workflow.scheme.unable.to.migrate.workflow.scheme");
        }
        catch (RejectedExecutionException e) {
            return this.error(ErrorCollection.Reason.SERVER_ERROR, "admin.project.workflow.scheme.unable.to.migrate.workflow.scheme");
        }
    }

    ServiceOutcome<String> copySystemWorkflow(Project project) {
        JiraServiceContext context = this.createContext();
        JiraWorkflow newWorkflow = this.workflowService.copyWorkflow(context, this.getWorkflowNameForProject(project), null, this.getDefaultWorkflow());
        if (newWorkflow == null || context.getErrorCollection().hasAnyErrors()) {
            return this.error(ErrorCollection.Reason.SERVER_ERROR, "admin.project.workflow.unable.to.copy.workflow");
        }
        return ServiceOutcomeImpl.ok((Object)newWorkflow.getName());
    }

    ServiceOutcome<Long> createNewSchemeFromWorkflow(String workflowName, Project project) {
        SchemeEntity entity = new SchemeEntity(workflowName, (Object)"0");
        try {
            Scheme scheme = new Scheme(null, null, this.getWorkflowSchemeNameForProject(project), Collections.singletonList(entity));
            scheme = this.workflowSchemeManager.createSchemeAndEntities(scheme);
            return ServiceOutcomeImpl.ok((Object)scheme.getId());
        }
        catch (DataAccessException e) {
            return this.error(ErrorCollection.Reason.SERVER_ERROR, "admin.project.workflow.scheme.unable.to.copy.workflow.scheme");
        }
    }

    private String getWorkflowSchemeNameForProject(Project project) {
        String name = this.generateWfSchemeNameForPrefix(project.getName());
        if (name == null && (name = this.generateWfSchemeNameForPrefix(project.getKey())) == null) {
            name = this.generateWfSchemeName();
        }
        return name;
    }

    private String generateWfSchemeNameForPrefix(String workflowSchemeNamePrefix) {
        if (workflowSchemeNamePrefix == null) {
            return null;
        }
        I18nHelper i18nHelper = this.authCtx.getI18nHelper();
        String newName = i18nHelper.getText("admin.project.workflow.scheme.name.template", workflowSchemeNamePrefix);
        int i = 2;
        while (!this.validateWorkflowSchemeName(newName) && newName.length() <= 255) {
            newName = i18nHelper.getText("admin.project.workflow.scheme.name.template.with.number", workflowSchemeNamePrefix, String.valueOf(i++));
        }
        return newName.length() > 255 ? null : newName;
    }

    private boolean validateWorkflowSchemeName(String newName) {
        try {
            return !this.workflowSchemeManager.schemeExists(newName);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private String generateWfSchemeName() {
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            String newName = this.authCtx.getI18nHelper().getText("admin.project.workflow.scheme.name.template.generic", (Object)i);
            if (!this.validateWorkflowSchemeName(newName)) continue;
            return newName;
        }
        throw new RuntimeException("Really you have this many workflow schemes?");
    }

    private String getWorkflowNameForProject(Project project) {
        String name = this.generateWfNameForPrefix(DefaultProjectConfigWorkflowDispatcher.convertToValidWorkflowName(project.getName()));
        if (name == null && (name = this.generateWfNameForPrefix(DefaultProjectConfigWorkflowDispatcher.convertToValidWorkflowName(project.getKey()))) == null) {
            name = this.generateWfName();
        }
        return name;
    }

    private String generateWfName() {
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            String newName = String.format("Workflow %d", i);
            if (!this.validateWorkflowName(newName)) continue;
            return newName;
        }
        throw new RuntimeException("Really you have this many workflows?");
    }

    private String generateWfNameForPrefix(String workflowNamePrefix) {
        if (workflowNamePrefix == null) {
            return null;
        }
        String newName = String.format("%s Workflow", workflowNamePrefix);
        int i = 2;
        while (!this.validateWorkflowName(newName) && newName.length() <= 255) {
            newName = String.format("%s Workflow %d", workflowNamePrefix, i++);
        }
        return newName.length() > 255 ? null : newName;
    }

    private JiraWorkflow getDefaultWorkflow() {
        JiraServiceContext context = this.createContext();
        return this.workflowService.getWorkflow(context, "jira");
    }

    private boolean validateWorkflowName(String newName) {
        JiraServiceContext context = this.createContext();
        this.workflowService.validateCopyWorkflow(context, newName);
        return !context.getErrorCollection().hasAnyErrors();
    }

    private static String convertToValidWorkflowName(String str) {
        String name = StringUtils.trimToNull((String)str);
        if (name == null) {
            return null;
        }
        if (WorkflowUtil.isAcceptableName((String)name)) {
            return name;
        }
        String normalize = Normalizer.normalize(name, Normalizer.Form.NFD);
        return WorkflowUtil.isAcceptableName((String)(normalize = DIACRITICAL_MARKS.matcher(normalize).replaceAll(""))) ? normalize : null;
    }

    private Project project(long projectId, ApplicationUser user) {
        ProjectService.GetProjectResult projectByIdForAction = this.projectService.getProjectByIdForAction(user, Long.valueOf(projectId), ProjectAction.EDIT_PROJECT_CONFIG);
        if (projectByIdForAction.isValid()) {
            return projectByIdForAction.getProject();
        }
        return null;
    }

    private Project project(String projectKey, ApplicationUser user) {
        ProjectService.GetProjectResult projectByIdForAction = this.projectService.getProjectByKeyForAction(user, projectKey, ProjectAction.EDIT_PROJECT_CONFIG);
        if (projectByIdForAction.isValid()) {
            return projectByIdForAction.getProject();
        }
        return null;
    }

    private JiraServiceContext createContext() {
        return new JiraServiceContextImpl(this.authCtx.getLoggedInUser(), (ErrorCollection)new SimpleErrorCollection(), this.authCtx.getI18nHelper());
    }

    private <T> ServiceOutcome<T> error(ErrorCollection.Reason reason, String ... keys) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        for (String key : keys) {
            errors.addErrorMessage(this.authCtx.getI18nHelper().getText(key));
        }
        errors.addReason(reason);
        return ServiceOutcomeImpl.from((ErrorCollection)errors, null);
    }

    private static <T> ServiceOutcome<T> error(ServiceOutcome<?> key) {
        return ServiceOutcomeImpl.from((ErrorCollection)key.getErrorCollection(), null);
    }
}

