/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.util;

import com.atlassian.jira.projectconfig.util.VelocityContextFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.JiraVelocityUtils;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultVelocityContextFactory
implements VelocityContextFactory {
    private final JiraAuthenticationContext authenticationContext;

    @Autowired
    public DefaultVelocityContextFactory(JiraAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    @Override
    public Map<String, Object> createVelocityContext(Map<String, Object> initContext) {
        return JiraVelocityUtils.getDefaultVelocityParams(initContext, (JiraAuthenticationContext)this.authenticationContext);
    }

    @Override
    public Map<String, Object> createDefaultVelocityContext() {
        return this.createVelocityContext(Collections.emptyMap());
    }
}

