/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.util;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderUtils;
import com.atlassian.jira.projectconfig.util.TabUrlFactory;
import com.atlassian.jira.projectconfig.util.UrlEncoder;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultTabUrlFactory
implements TabUrlFactory {
    private final ContextProviderUtils providerUtils;
    private final UrlEncoder encoder;
    private final FeatureManager featureManager;

    @Autowired
    public DefaultTabUrlFactory(ContextProviderUtils providerUtils, UrlEncoder encoder, FeatureManager featureManager) {
        this.providerUtils = providerUtils;
        this.encoder = encoder;
        this.featureManager = featureManager;
    }

    @Override
    public String forSummary() {
        return this.forTab(null);
    }

    @Override
    public String forComponents() {
        return this.forTab("administer-components");
    }

    @Override
    public String forVersions() {
        return this.forTab("administer-versions");
    }

    @Override
    public String forIssueSecurity() {
        return this.forTab("issuesecurity");
    }

    @Override
    public String forPermissions() {
        return this.forTab("permissions");
    }

    @Override
    public String forWorkflows() {
        return this.forTab("workflows");
    }

    @Override
    public String forFields() {
        return this.forTab("fields");
    }

    @Override
    public String forScreens() {
        return this.forTab("screens");
    }

    @Override
    public String forNotifications() {
        return this.forTab("notifications");
    }

    @Override
    public String forIssueTypes() {
        return this.forTab("issuetypes");
    }

    @Override
    public String forPriorities() {
        return this.forTab("priorities");
    }

    private String forTab(String tab) {
        Project project = this.providerUtils.getProject();
        StringBuilder builder = new StringBuilder(StringUtils.stripToEmpty((String)this.providerUtils.getBaseUrl()));
        if (builder.length() == 0 || builder.charAt(0) != '/') {
            builder.insert(0, '/');
        }
        this.appendPath(builder, "plugins/servlet/project-config/");
        this.appendPath(builder, this.encoder.encode(project.getKey()));
        if (tab != null) {
            this.appendPath(builder, this.encoder.encode(tab));
        }
        return builder.toString();
    }

    private void appendPath(StringBuilder url, String path) {
        if (url.charAt(url.length() - 1) != '/') {
            url.append('/');
        }
        url.append(path);
    }
}

