/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.util;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.beans.ProjectWorkflowContext;
import com.atlassian.jira.projectconfig.util.ProjectWorkflowContextLocator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultProjectWorkflowContextLocator
implements ProjectWorkflowContextLocator {
    private final ProjectService projectService;
    private final JiraAuthenticationContext authContext;
    private final WorkflowManager workflowManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final PermissionManager permissionManager;

    @Autowired
    public DefaultProjectWorkflowContextLocator(@ComponentImport ProjectService projectService, @ComponentImport JiraAuthenticationContext authContext, @ComponentImport WorkflowManager workflowManager, @ComponentImport WorkflowSchemeManager workflowSchemeManager, @ComponentImport PermissionManager permissionManager) {
        this.projectService = projectService;
        this.authContext = authContext;
        this.workflowManager = workflowManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.permissionManager = permissionManager;
    }

    @Override
    @Nonnull
    public ServiceOutcome<ProjectWorkflowContext> getContext(String projectKey, @Nonnull String workflowName) {
        boolean isAdmin = this.permissionManager.hasPermission(0, this.authContext.getLoggedInUser());
        Project project = null;
        if (projectKey != null) {
            ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKeyForAction(this.authContext.getUser(), projectKey, ProjectAction.EDIT_PROJECT_CONFIG);
            if (!projectResult.isValid()) {
                return ServiceOutcomeImpl.from((ErrorCollection)projectResult.getErrorCollection());
            }
            project = projectResult.getProject();
        } else if (!isAdmin) {
            return ServiceOutcomeImpl.error((String)this.authContext.getI18nHelper().getText("rest.project.key.invalid", ""), (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED);
        }
        JiraWorkflow workflow = this.workflowManager.getWorkflow(workflowName);
        if (workflow == null || !isAdmin && !this.doesWorkflowBelongToProject(project, workflowName)) {
            return ServiceOutcomeImpl.error((String)this.authContext.getI18nHelper().getText("admin.workflow.not.in.project"), (ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND);
        }
        return ServiceOutcomeImpl.ok((Object)new ProjectWorkflowContext(project, workflow));
    }

    private boolean doesWorkflowBelongToProject(Project project, String workflowName) {
        Map workflowMap = this.workflowSchemeManager.getWorkflowMap(project);
        String defaultWorkflowName = this.getDefaultWorkflowName(workflowMap);
        for (IssueType types : project.getIssueTypes()) {
            String workflow = (String)workflowMap.get(types.getId());
            if (workflow == null) {
                workflow = defaultWorkflowName;
            }
            if (!workflow.equals(workflowName)) continue;
            return true;
        }
        return false;
    }

    private String getDefaultWorkflowName(@Nonnull Map<String, String> workflowMap) {
        if (workflowMap.get(null) != null) {
            return workflowMap.get(null);
        }
        return "jira";
    }
}

