/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.tab;

import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.ProjectFieldScreenHelper;
import com.atlassian.jira.projectconfig.tab.ProjectConfigTabRenderContext;
import com.atlassian.jira.projectconfig.tab.WebPanelTab;
import com.atlassian.jira.projectconfig.util.VelocityContextFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ScreensTab
extends WebPanelTab {
    public static final String CONTEXT_SCREEN = "screen";
    private static Jsonable EMPTY_OBJECT_JSONABLE = writer -> writer.write("{}");
    private static final Logger log = LoggerFactory.getLogger(ScreensTab.class);
    private static final String SCREENEDITOR_DATA_KEY = "com.atlassian.jira.jira-project-config-plugin:screenEditInfo";
    private final ProjectFieldScreenHelper screenHelper;
    private final FieldScreenManager fieldScreenManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public ScreensTab(WebInterfaceManager webInterfaceManager, VelocityContextFactory factory, ProjectFieldScreenHelper screenHelper, FieldScreenManager fieldScreenManager, JiraAuthenticationContext jiraAuthenticationContext) {
        super(webInterfaceManager, factory, "screens", "view_project_screens");
        this.screenHelper = screenHelper;
        this.fieldScreenManager = fieldScreenManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public String getTitle(ProjectConfigTabRenderContext context) {
        return context.getI18NHelper().getText("admin.project.screens.title", context.getProject().getName());
    }

    @Override
    public void addResourceForProject(ProjectConfigTabRenderContext context) {
        WebResourceAssembler assembler = context.getPageBuilderService().assembler();
        assembler.data().requireData(SCREENEDITOR_DATA_KEY, this.addScreenRelevantData(context));
        assembler.resources().requireWebResource("com.atlassian.jira.jira-project-config-plugin:screen-view-resources");
    }

    @Override
    protected WebPanel getBodyWebPanel(Map<String, Object> velocityContext) {
        if (!velocityContext.containsKey(CONTEXT_SCREEN)) {
            return super.getBodyWebPanel(velocityContext);
        }
        return this.getWebPanel("tabs.admin.projectconfig.screenview", velocityContext, true);
    }

    @Override
    protected Map<String, Object> createVelocityContext(ProjectConfigTabRenderContext context) {
        ImmutableMap.Builder velocityContext = ImmutableMap.builder().putAll(super.createVelocityContext(context));
        Optional<FieldScreen> screen = this.getScreen(context.getPathInfo());
        screen.ifPresent(fieldScreen -> velocityContext.put((Object)CONTEXT_SCREEN, fieldScreen));
        return velocityContext.build();
    }

    private Jsonable addScreenRelevantData(ProjectConfigTabRenderContext context) {
        Optional<FieldScreen> screen = this.getScreen(context.getPathInfo());
        if (!screen.isPresent()) {
            return EMPTY_OBJECT_JSONABLE;
        }
        FieldScreen fieldScreen = screen.get();
        try {
            JSONObject json = new JSONObject();
            json.put("screenId", (Object)fieldScreen.getId());
            json.put("canEdit", this.screenHelper.canUserEditScreen(this.jiraAuthenticationContext.getLoggedInUser(), fieldScreen));
            json.put("state", (Object)this.screenHelper.getUserEditScreenPermission(this.jiraAuthenticationContext.getLoggedInUser(), fieldScreen).simpleName());
            json.put("projectKey", (Object)context.getProject().getKey());
            return writer -> {
                try {
                    json.write(writer);
                }
                catch (JSONException e) {
                    log.warn("Cannot write JSON representation for screen " + fieldScreen.getId(), (Throwable)e);
                }
            };
        }
        catch (JSONException e) {
            log.warn("Cannot create JSON representation for screen " + fieldScreen.getId(), (Throwable)e);
            return EMPTY_OBJECT_JSONABLE;
        }
    }

    private Optional<FieldScreen> getScreen(String extraURI) {
        if (StringUtils.isBlank((CharSequence)extraURI)) {
            return Optional.empty();
        }
        try {
            long screenID = Long.parseLong(extraURI);
            FieldScreen fieldScreen = this.fieldScreenManager.getFieldScreen(Long.valueOf(screenID));
            if (fieldScreen == null) {
                return Optional.empty();
            }
            return Optional.of(fieldScreen);
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }
}

