/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.tab;

import com.atlassian.jira.projectconfig.dataproviders.PermissionsDataProvider;
import com.atlassian.jira.projectconfig.tab.ProjectConfigTabRenderContext;
import com.atlassian.jira.projectconfig.tab.WebPanelTab;
import com.atlassian.jira.projectconfig.util.VelocityContextFactory;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionsTab
extends WebPanelTab {
    static final String PERMISSIONS_DATA_KEY = "com.atlassian.jira.jira-project-config-plugin:permissions-data.permissionSchemeModel";
    private final PermissionsDataProvider permissionsDataProvider;
    private static ObjectMapper OBJECT_MAPPER;

    @Autowired
    public PermissionsTab(WebInterfaceManager webInterfaceManager, VelocityContextFactory factory, PermissionsDataProvider permissionsDataProvider) {
        super(webInterfaceManager, factory, "permissions", "view_project_permissions");
        this.permissionsDataProvider = permissionsDataProvider;
    }

    @Override
    public String getTitle(ProjectConfigTabRenderContext context) {
        return context.getI18NHelper().getText("admin.project.permissions.title", context.getProject().getName());
    }

    @Override
    public void addResourceForProject(ProjectConfigTabRenderContext context) {
        WebResourceAssembler assembler = context.getPageBuilderService().assembler();
        assembler.resources().requireWebResource("com.atlassian.jira.jira-project-config-plugin:permissions-resources");
        assembler.data().requireData(PERMISSIONS_DATA_KEY, writer -> OBJECT_MAPPER.writeValue(writer, (Object)this.permissionsDataProvider.getProjectPermissionSchemeBean(context.getUser(), context.getProject())));
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        OBJECT_MAPPER = mapper;
    }
}

