/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.tab;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.tab.ProjectConfigTab;
import com.atlassian.jira.projectconfig.tab.ProjectConfigTabRenderContext;
import com.atlassian.jira.projectconfig.util.VelocityContextFactory;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.model.WebPanel;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueTypesTab
implements ProjectConfigTab {
    private final WebInterfaceManager webInterfaceManager;
    private final VelocityContextFactory contextFactory;
    private static final Pattern URL_PARSER = Pattern.compile("project-config/+([^/]+)/+issuetypes/*(?:(?<=/)(\\d+)/*)?$");
    public static final String URL = "url";
    public static final String ERROR = "error";

    @Autowired
    public IssueTypesTab(WebInterfaceManager webInterfaceManager, VelocityContextFactory contextFactory) {
        this.webInterfaceManager = webInterfaceManager;
        this.contextFactory = contextFactory;
    }

    @Override
    public String getId() {
        return "issuetypes";
    }

    @Override
    public String getLinkId() {
        return "view_project_issuetypes";
    }

    @Override
    public String getTab(ProjectConfigTabRenderContext context) {
        if (this.isSummaryRequest(context.getRequest().getRequestURI())) {
            return this.renderSummary(context.getProject());
        }
        return "";
    }

    @Override
    public String getTitle(ProjectConfigTabRenderContext context) {
        return context.getI18NHelper().getText("admin.project.issuetypes.title", context.getProject().getName());
    }

    @Override
    public void addResourceForProject(ProjectConfigTabRenderContext context) {
        context.getResourceManager().requireResource("com.atlassian.jira.jira-project-config-plugin:issuetypes-tab");
    }

    private String renderSummary(Project project) {
        ImmutableMap ourContext = ImmutableMap.of((Object)"atl.jira.admin.current.project", (Object)project);
        Map<String, Object> context = this.contextFactory.createVelocityContext((Map<String, Object>)ourContext);
        List panels = this.webInterfaceManager.getDisplayableWebPanels("tabs.admin.projectconfig.issuetypes", this.contextFactory.createVelocityContext((Map<String, Object>)ourContext));
        WebPanel panel = (WebPanel)Iterables.getFirst((Iterable)panels, null);
        if (panel == null) {
            return "";
        }
        return panel.getHtml(context);
    }

    private boolean isSummaryRequest(String uri) {
        Matcher matcher = URL_PARSER.matcher(uri);
        return matcher.find() && matcher.group(2) == null;
    }
}

