/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.shared;

import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SharedIssueTypeWorkflowData {
    private final List<Project> projects;
    private final List<IssueType> issueTypes;
    private final long totalProjectsCount;

    public SharedIssueTypeWorkflowData(List<Project> allowedProjects, List<IssueType> issueTypes, long totalProjectsCount) {
        this.projects = Collections.unmodifiableList(allowedProjects);
        this.issueTypes = Collections.unmodifiableList(issueTypes);
        this.totalProjectsCount = totalProjectsCount;
    }

    @VisibleForTesting
    public SharedIssueTypeWorkflowData(List<Project> allowedProjects, List<IssueType> issueTypes) {
        this(allowedProjects, issueTypes, allowedProjects.size());
    }

    @VisibleForTesting
    public SharedIssueTypeWorkflowData(List<Project> allowedProjects) {
        this(allowedProjects, Collections.emptyList(), allowedProjects.size());
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    public List<IssueType> getIssueTypes() {
        return this.issueTypes;
    }

    public long getHiddenProjectsCount() {
        return this.totalProjectsCount - (long)this.projects.size();
    }

    public long getTotalProjectsCount() {
        return this.totalProjectsCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharedIssueTypeWorkflowData that = (SharedIssueTypeWorkflowData)o;
        return this.totalProjectsCount == that.totalProjectsCount && Objects.equals(this.projects, that.projects) && Objects.equals(this.issueTypes, that.issueTypes);
    }

    public int hashCode() {
        return Objects.hash(this.projects, this.issueTypes, this.totalProjectsCount);
    }

    public String toString() {
        return "SharedIssueTypeWorkflowData{projects=" + this.projects + ", totalProjectsCount=" + this.totalProjectsCount + ", hiddenProjectsCount=" + this.getHiddenProjectsCount() + ", issueTypes=" + this.issueTypes + '}';
    }
}

