/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.shared;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.ProjectFieldScreenHelper;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.priority.PrioritySchemeHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.order.OrderFactory;
import com.atlassian.jira.projectconfig.rest.beans.SharedByData;
import com.atlassian.jira.projectconfig.rest.beans.SimpleRestProject;
import com.atlassian.jira.projectconfig.shared.SharedIssueTypeWorkflowData;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.ProjectWorkflowSchemeHelper;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SharedEntitiesHelper {
    private final OrderFactory orderFactory;
    private final ProjectService projectService;
    private final WorkflowManager workflowManager;
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectWorkflowSchemeHelper projectWorkflowSchemeHelper;
    private final ProjectFieldScreenHelper projectFieldScreenHelper;
    private final PrioritySchemeHelper prioritySchemeHelper;

    @Autowired
    public SharedEntitiesHelper(OrderFactory orderFactory, ProjectService projectService, WorkflowManager workflowManager, JiraAuthenticationContext authenticationContext, @ComponentImport ProjectWorkflowSchemeHelper projectWorkflowSchemeHelper, @ComponentImport ProjectFieldScreenHelper projectFieldScreenHelper, @ComponentImport PrioritySchemeHelper prioritySchemeHelper) {
        this.orderFactory = orderFactory;
        this.projectService = projectService;
        this.workflowManager = workflowManager;
        this.authenticationContext = authenticationContext;
        this.projectWorkflowSchemeHelper = projectWorkflowSchemeHelper;
        this.projectFieldScreenHelper = projectFieldScreenHelper;
        this.prioritySchemeHelper = prioritySchemeHelper;
    }

    public static String getOrDefaultWorkflowName(Map<String, String> issueTypeToWorkflowMap, @Nullable String issueTypeId, String defaultWorkflowName) {
        String workflowName = issueTypeToWorkflowMap.get(issueTypeId);
        return workflowName == null ? defaultWorkflowName : workflowName;
    }

    @Deprecated
    public SharedIssueTypeWorkflowData getSharedData(Project project, IssueType issueType, String workflowName) {
        return this.getSharedData(project, workflowName);
    }

    public SharedIssueTypeWorkflowData getSharedData(FieldScreen screen) {
        return this.getSharedData(screen, Collections.emptyList());
    }

    public SharedIssueTypeWorkflowData getSharedData(FieldScreen screen, List<IssueType> issueTypes) {
        List<Project> projects = this.getAllProjectsForScreen(screen);
        List<Project> allowedProjects = this.filterSharingProjects(projects);
        return this.createWorkflowData(issueTypes, allowedProjects, projects.size());
    }

    public SharedIssueTypeWorkflowData getSharedData(Project project, String workflowName) {
        List<Project> projects = this.getAllProjectsForWorkflow(workflowName);
        List<IssueType> issueTypes = this.getSharingIssueTypes(project, workflowName);
        List<Project> allowedProjects = this.filterSharingProjects(projects);
        return this.createWorkflowData(issueTypes, allowedProjects, projects.size());
    }

    public SharedByData getSharedDataForPriorities(FieldConfigScheme fieldConfigScheme) {
        List projects = this.prioritySchemeHelper.getProjectsForScheme(fieldConfigScheme);
        List<SimpleRestProject> accessibleProjects = this.filterSharingProjects(projects).stream().map(SimpleRestProject::shortProject).collect(Collectors.toList());
        return new SharedByData(accessibleProjects, projects.size());
    }

    private SharedIssueTypeWorkflowData createWorkflowData(List<IssueType> issueTypes, List<Project> visibleProjects, int hiddenProjectsCount) {
        return new SharedIssueTypeWorkflowData(visibleProjects, issueTypes, hiddenProjectsCount);
    }

    public List<Project> getAllProjectsForScheme(Long schemeId) {
        return this.projectWorkflowSchemeHelper.getAllProjectsForScheme(schemeId);
    }

    public List<Project> getAllProjectsForWorkflow(String workflowName) {
        return this.projectWorkflowSchemeHelper.getAllProjectsForWorkflow(workflowName);
    }

    public List<Project> getAllProjectsForScreen(FieldScreen screen) {
        return this.projectFieldScreenHelper.getAllProjectsForFieldScreen(screen);
    }

    public List<Project> filterSharingProjects(Collection<Project> allProjects) {
        return (List)this.getAllAccessibleProjects().stream().filter(allProjects::contains).collect(CollectorsUtil.toImmutableList());
    }

    private List<IssueType> getSharingIssueTypes(Project project, String workflowName) {
        List result = (List)project.getIssueTypes().stream().filter(issueType -> {
            String issueTypeWorkflowName = this.workflowManager.getWorkflow(project.getId(), issueType.getId()).getName();
            return Objects.equals(issueTypeWorkflowName, workflowName);
        }).collect(CollectorsUtil.toImmutableList());
        return this.orderFactory.createTranslatedNameOrder().immutableSortedCopy((Iterable)result);
    }

    private List<Project> getAllAccessibleProjects() {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        ServiceOutcome result = this.projectService.getAllProjectsForAction(user, ProjectAction.EDIT_PROJECT_CONFIG);
        if (!result.isValid()) {
            return Collections.emptyList();
        }
        return (List)result.getReturnedValue();
    }
}

