/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.servlet;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.jira.admin.TabLoadedDataProvider;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatUtils;
import com.atlassian.jira.event.mau.MauApplicationKey;
import com.atlassian.jira.event.mau.MauEventService;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.warning.InaccessibleProjectTypeDialogDataProvider;
import com.atlassian.jira.projectconfig.event.SummaryPageLoadedEvent;
import com.atlassian.jira.projectconfig.tab.DefaultTabRenderContext;
import com.atlassian.jira.projectconfig.tab.ProjectConfigTab;
import com.atlassian.jira.projectconfig.tab.ProjectConfigTabManager;
import com.atlassian.jira.projectconfig.util.ProjectConfigRequestCache;
import com.atlassian.jira.projectconfig.util.VelocityContextFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.http.JiraHttpUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.seraph.util.RedirectUtils;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.opensymphony.module.propertyset.PropertySet;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;

public class PanelServlet
extends HttpServlet {
    static final Pattern PATTERN = Pattern.compile("/*project-config/+([^/]+)/*(?:(?<=/)([^/]+)/*(?:(?<=/)(.+))?)?");
    private static final Logger log = Logger.getLogger(PanelServlet.class);
    private static final String CONTEXT_PROJECT_KEY_ENCODED = "projectKeyEncoded";
    private static final String TEMPLATE_TAB = "global/tab.vm";
    private static final String TEMPLATE_ERROR = "global/taberror.vm";
    private static final String PROJECT_SETTINGS_GROUP_ONE_KEY = "atl.jira.proj.config/projectgroup1";
    private static final ObjectMapper OBJECT_MAPPER;
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectConfigTabManager tabManager;
    private final ProjectService service;
    private final TemplateRenderer templateRenderer;
    private final WebResourceManager webResourceManager;
    private final PageBuilderService pageBuilderService;
    private final ApplicationProperties properties;
    private final VelocityContextFactory velocityContextFactory;
    private final UserProjectHistoryManager userProjectHistoryManager;
    private final ProjectConfigRequestCache cache;
    private final EventPublisher eventPublisher;
    private final InaccessibleProjectTypeDialogDataProvider inaccessibleProjectTypeDialogDataProvider;
    private final MauEventService mauEventService;
    private final UserPropertyManager userPropertyManager;
    private final WebInterfaceManager webInterfaceManager;
    private final TabLoadedDataProvider tabLoadedDataProvider;

    public PanelServlet(JiraAuthenticationContext authenticationContext, ProjectConfigTabManager tabManager, ProjectService service, TemplateRenderer templateRenderer, WebResourceManager webResourceManager, PageBuilderService pageBuilderService, ApplicationProperties properties, VelocityContextFactory velocityContextFactory, UserProjectHistoryManager userHistoryManager, ProjectConfigRequestCache cache, EventPublisher eventPublisher, InaccessibleProjectTypeDialogDataProvider inaccessibleProjectTypeDialogDataProvider, MauEventService mauEventService, UserPropertyManager userPropertyManager, WebInterfaceManager webInterfaceManager, @ComponentImport TabLoadedDataProvider tabLoadedDataProvider) {
        this.authenticationContext = authenticationContext;
        this.tabManager = tabManager;
        this.service = service;
        this.templateRenderer = templateRenderer;
        this.webResourceManager = webResourceManager;
        this.pageBuilderService = pageBuilderService;
        this.properties = properties;
        this.velocityContextFactory = velocityContextFactory;
        this.userProjectHistoryManager = userHistoryManager;
        this.cache = cache;
        this.eventPublisher = eventPublisher;
        this.inaccessibleProjectTypeDialogDataProvider = inaccessibleProjectTypeDialogDataProvider;
        this.mauEventService = mauEventService;
        this.userPropertyManager = userPropertyManager;
        this.webInterfaceManager = webInterfaceManager;
        this.tabLoadedDataProvider = tabLoadedDataProvider;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Matcher matcher = PATTERN.matcher(req.getPathInfo());
        if (matcher.matches()) {
            String projectKey = matcher.group(1);
            ApplicationUser user = this.authenticationContext.getLoggedInUser();
            ProjectService.GetProjectResult result = this.service.getProjectByKeyForAction(user, projectKey, ProjectAction.EDIT_PROJECT_CONFIG);
            if (!result.isValid()) {
                if (user == null) {
                    this.redirectToLogin(req, resp);
                } else {
                    this.tagMauEventWithFamily();
                    I18nHelper i18nHelper = this.authenticationContext.getI18nHelper();
                    this.outputError(resp, this.flattenMessages(result.getErrorCollection()), i18nHelper.getText("common.words.error"));
                }
            } else {
                Project project = result.getProject();
                String projectPanel = matcher.group(2);
                if (projectPanel == null) {
                    this.redirectToFirstMenuItem(req, resp, project);
                } else {
                    ProjectConfigTab tab = this.tabManager.getTabForId(projectPanel);
                    if (tab == null) {
                        this.tagMauEventWithFamily();
                        I18nHelper i18nHelper = this.authenticationContext.getI18nHelper();
                        this.outputError(resp, i18nHelper.getText("admin.project.servlet.no.tab", projectPanel), i18nHelper.getText("common.words.error"));
                    } else {
                        this.tagMauEventWithProject(project);
                        this.userProjectHistoryManager.addProjectToHistory(this.authenticationContext.getLoggedInUser(), project);
                        PropertySet userProperties = this.userPropertyManager.getPropertySet(user);
                        String projectKeyFromResult = project.getKey();
                        String tabId = tab.getId();
                        userProperties.setString("atl.jira.admin.current.project", projectKeyFromResult);
                        userProperties.setString("atl.jira.admin.current.project.tab", tabId);
                        userProperties.setString("atl.jira.admin.current.project.return.url", this.getUrlWithoutContext(req));
                        if ("summary".equals(projectPanel)) {
                            this.eventPublisher.publish((Object)new SummaryPageLoadedEvent(project.getId(), projectKeyFromResult));
                        }
                        this.outputTab(req, resp, project, tab, matcher.group(3));
                    }
                }
            }
        } else {
            this.tagMauEventWithFamily();
            I18nHelper i18nHelper = this.authenticationContext.getI18nHelper();
            this.outputError(resp, i18nHelper.getText("admin.project.servlet.no.project"), i18nHelper.getText("common.words.error"));
        }
    }

    private String getUrlWithoutContext(HttpServletRequest req) {
        StringBuilder builder = new StringBuilder(StringUtils.removeStart((String)req.getRequestURI(), (String)req.getContextPath()));
        if (StringUtils.isNotBlank((String)req.getQueryString())) {
            builder.append('?').append(req.getQueryString());
        }
        return builder.toString();
    }

    @VisibleForTesting
    void redirectToLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.sendRedirect(RedirectUtils.getLoginUrl((HttpServletRequest)req));
    }

    @VisibleForTesting
    void outputTab(HttpServletRequest request, HttpServletResponse reponse, Project project, ProjectConfigTab tab, String extra) throws IOException {
        this.cache.setProject(project);
        JiraHttpUtils.setNoCacheHeaders((HttpServletResponse)reponse);
        this.requireResources();
        this.requireData(project);
        DefaultTabRenderContext ctx = new DefaultTabRenderContext(extra, project, this.authenticationContext, this.webResourceManager, this.pageBuilderService);
        tab.addResourceForProject(ctx);
        Map<String, Object> context = this.velocityContextFactory.createVelocityContext(MapBuilder.newBuilder().add((Object)"project", (Object)project).add((Object)"tabHtml", (Object)tab.getTab(ctx)).add((Object)"req", (Object)request).add((Object)"linkId", (Object)tab.getLinkId()).add((Object)"title", (Object)tab.getTitle(ctx)).add((Object)"dateFormat", (Object)DateTimeFormatUtils.getDateFormat()).add((Object)"timeFormat", (Object)DateTimeFormatUtils.getTimeFormat()).toMap());
        this.writeTemplate(reponse, TEMPLATE_TAB, context);
    }

    private void redirectToFirstMenuItem(HttpServletRequest request, HttpServletResponse response, Project project) throws IOException {
        Map<String, Object> context = this.getMenuItemContext(request, project);
        Option<WebItemModuleDescriptor> smallestWeightItem = this.getSmallestWeightWebItem(PROJECT_SETTINGS_GROUP_ONE_KEY, context);
        if (!smallestWeightItem.isDefined()) {
            throw new RuntimeException(String.format("Unexpected error: There should be at least one element in the first project group: '%s'", PROJECT_SETTINGS_GROUP_ONE_KEY));
        }
        response.sendRedirect(this.getWebItemUrl(request, (WebItemModuleDescriptor)smallestWeightItem.get(), context));
    }

    private Option<WebItemModuleDescriptor> getSmallestWeightWebItem(String section, Map<String, Object> context) {
        return Option.option(Lists.newArrayList((Iterable)this.webInterfaceManager.getDisplayableItems(section, context)).stream().sorted((o1, o2) -> o1.getWeight() - o2.getWeight()).findFirst().orElse(null));
    }

    private String getWebItemUrl(HttpServletRequest request, WebItemModuleDescriptor webItem, Map<String, Object> context) {
        return webItem.getLink().getDisplayableUrl(request, context);
    }

    private Map<String, Object> getMenuItemContext(HttpServletRequest request, Project project) {
        MapBuilder contextBuilder = MapBuilder.newBuilder();
        contextBuilder.add((Object)CONTEXT_PROJECT_KEY_ENCODED, (Object)JiraUrlCodec.encode((String)project.getKey(), (boolean)true));
        contextBuilder.add((Object)"user", (Object)this.authenticationContext.getLoggedInUser());
        contextBuilder.add((Object)"helper", (Object)new JiraHelper(request, project));
        return contextBuilder.toMap();
    }

    private void outputError(HttpServletResponse reponse, String errorMessage, String title) throws IOException {
        this.outputError(reponse, Collections.singleton(errorMessage), title);
    }

    void outputError(HttpServletResponse reponse, Collection<String> errorMessage, String title) throws IOException {
        JiraHttpUtils.setNoCacheHeaders((HttpServletResponse)reponse);
        this.requireResources();
        Map<String, Object> context = this.velocityContextFactory.createVelocityContext(MapBuilder.newBuilder().add((Object)"errorMessages", errorMessage).add((Object)"title", (Object)title).toMap());
        this.writeTemplate(reponse, TEMPLATE_ERROR, context);
    }

    private void writeTemplate(HttpServletResponse reponse, String template, Map<String, Object> context) throws IOException {
        reponse.setContentType(this.getContentType());
        try (PrintWriter writer = reponse.getWriter();){
            this.templateRenderer.render(template, context, (Writer)writer);
        }
    }

    private String getContentType() {
        try {
            return this.properties.getContentType();
        }
        catch (Exception e) {
            return "text/html; charset=UTF-8";
        }
    }

    private Collection<String> flattenMessages(ErrorCollection collection) {
        if (!collection.hasAnyErrors()) {
            return Collections.emptyList();
        }
        LinkedHashSet messages = Sets.newLinkedHashSet();
        messages.addAll(collection.getErrorMessages());
        messages.addAll(collection.getErrors().values());
        return messages;
    }

    private void requireData(Project project) {
        this.requireProjectTypesData(project);
        this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.jira-project-config-plugin:app-data", writer -> OBJECT_MAPPER.writeValue(writer, (Object)ImmutableMap.of((Object)"projectKey", (Object)project.getKey())));
        this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.jira-project-config-plugin:analytics-common-data", writer -> {
            ApplicationUser user = this.authenticationContext.getLoggedInUser();
            OBJECT_MAPPER.writeValue(writer, (Object)ImmutableMap.of((Object)"hasExtPermission", (Object)this.tabLoadedDataProvider.hasExtPermission(project), (Object)"isAdmin", (Object)this.tabLoadedDataProvider.isAdmin(user), (Object)"projectId", (Object)project.getId()));
        });
    }

    private void requireProjectTypesData(Project project) {
        ApplicationUser loggedInUser = this.authenticationContext.getLoggedInUser();
        if (this.inaccessibleProjectTypeDialogDataProvider.shouldDisplayInaccessibleWarning(loggedInUser, project)) {
            this.inaccessibleProjectTypeDialogDataProvider.provideData(this.pageBuilderService.assembler(), loggedInUser, project);
        }
    }

    private void requireResources() {
        this.webResourceManager.requireResourcesForContext("jira.admin.conf");
        this.webResourceManager.requireResource("com.atlassian.jira.jira-project-config-plugin:project-config-global");
    }

    private void tagMauEventWithProject(Project project) {
        try {
            this.mauEventService.setApplicationForThreadBasedOnProject(project);
        }
        catch (Exception e) {
            log.warn((Object)("Exception thrown from MAUEventService.setApplicationForThreadBasedOnProject:" + e.getMessage()), (Throwable)e);
        }
    }

    private void tagMauEventWithFamily() {
        try {
            this.mauEventService.setApplicationForThread(MauApplicationKey.family());
        }
        catch (Exception e) {
            log.warn((Object)("Exception thrown from MAUEventService.setApplicationForThread:" + e.getMessage()), (Throwable)e);
        }
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        OBJECT_MAPPER = mapper;
    }
}

