/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.servlet;

import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.projectconfig.order.OrderFactory;
import com.atlassian.jira.projectconfig.util.VelocityContextFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.http.JiraHttpUtils;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class InlineDialogServlet
extends HttpServlet {
    private static final String PARAM_FIELD_ID = "fieldId";
    private static final String PARAM_PROJECT_KEY = "projectKey";
    private static final String DIALOG_VM = "screens/screensdialog.vm";
    private static final String WARNING_VM = "screens/warningpanel.vm";
    private static final String CONTEXT_SCREENS = "screens";
    private static final String CONTEXT_ERROR = "message";
    private final FieldScreenManager fieldScreenManager;
    private final TemplateRenderer templateRenderer;
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectService projectService;
    private final OrderFactory orderFactory;
    private final VelocityContextFactory velocityContextFactory;

    public InlineDialogServlet(OrderFactory orderFactory, FieldScreenManager fieldScreenManager, TemplateRenderer templateRenderer, JiraAuthenticationContext authenticationContext, ProjectService projectService, VelocityContextFactory velocityContextFactory) {
        this.orderFactory = orderFactory;
        this.fieldScreenManager = fieldScreenManager;
        this.templateRenderer = templateRenderer;
        this.authenticationContext = authenticationContext;
        this.projectService = projectService;
        this.velocityContextFactory = velocityContextFactory;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.checkPermission(InlineDialogServlet.getKey(req))) {
            this.renderWarning(resp, this.authenticationContext.getI18nHelper().getText("admin.project.fields.screens.perm.error"));
        } else {
            String fieldId = InlineDialogServlet.getFieldId(req);
            if (fieldId == null) {
                resp.sendError(400, "No fieldId specified");
                resp.setContentLength(0);
            } else {
                this.renderScreens(resp, fieldId);
            }
        }
    }

    private void renderScreens(HttpServletResponse response, String fieldId) throws IOException {
        Collection fieldScreenTabs = this.fieldScreenManager.getFieldScreenTabs(fieldId);
        ArrayList beans = Lists.newArrayListWithExpectedSize((int)fieldScreenTabs.size());
        for (FieldScreenTab tab : fieldScreenTabs) {
            FieldScreen fieldScreen = tab.getFieldScreen();
            beans.add(fieldScreen);
        }
        final Comparator<String> comparator = this.orderFactory.createStringComparator();
        Collections.sort(beans, new Comparator<FieldScreen>(){

            @Override
            public int compare(FieldScreen o1, FieldScreen o2) {
                return comparator.compare(o1.getName(), o2.getName());
            }
        });
        this.writeTemplate(response, DIALOG_VM, this.velocityContextFactory.createVelocityContext((Map<String, Object>)ImmutableMap.of((Object)CONTEXT_SCREENS, (Object)beans)));
    }

    private void renderWarning(HttpServletResponse response, String error) throws IOException {
        this.writeTemplate(response, WARNING_VM, this.velocityContextFactory.createVelocityContext((Map<String, Object>)ImmutableMap.of((Object)CONTEXT_ERROR, (Object)error)));
    }

    private void writeTemplate(HttpServletResponse reponse, String template, Map<String, Object> context) throws IOException {
        JiraHttpUtils.setNoCacheHeaders((HttpServletResponse)reponse);
        try (PrintWriter writer = reponse.getWriter();){
            this.templateRenderer.render(template, context, (Writer)writer);
        }
    }

    private boolean checkPermission(String key) {
        if (key == null) {
            return false;
        }
        ProjectService.GetProjectResult allProjectsForAction = this.projectService.getProjectByKeyForAction(this.authenticationContext.getLoggedInUser(), key, ProjectAction.EDIT_PROJECT_CONFIG);
        return allProjectsForAction.isValid() && allProjectsForAction.getProject() != null;
    }

    private static String getFieldId(HttpServletRequest req) {
        return InlineDialogServlet.getParameter(req, PARAM_FIELD_ID);
    }

    private static String getKey(HttpServletRequest req) {
        return InlineDialogServlet.getParameter(req, PARAM_PROJECT_KEY);
    }

    private static String getParameter(HttpServletRequest req, String parameterName) {
        return StringUtils.stripToNull((String)req.getParameter(parameterName));
    }
}

