/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.rest.project;

import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskProgressEvent;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationResult;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@Path(value="migrationStatus")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class MigrationStatusResource {
    private final JiraAuthenticationContext authCtx;
    private final PermissionManager permissionManager;
    private final TaskManager taskManager;

    public MigrationStatusResource(JiraAuthenticationContext authCtx, PermissionManager permissionManager, TaskManager taskManager) {
        this.authCtx = authCtx;
        this.permissionManager = permissionManager;
        this.taskManager = taskManager;
    }

    @GET
    @Path(value="{id}")
    public Response getMigrationStatus(@PathParam(value="id") long id) {
        if (!this.permissionManager.hasPermission(0, this.authCtx.getLoggedInUser())) {
            return MigrationStatusResource.forbidden();
        }
        TaskDescriptor task = this.taskManager.getTask(Long.valueOf(id));
        if (task == null) {
            return MigrationStatusResource.notFound();
        }
        if (task.isFinished()) {
            TaskStatus taskStatus = new TaskStatus((WorkflowMigrationResult)task.getResult());
            return Response.ok((Object)taskStatus).cacheControl(CacheControl.never()).build();
        }
        TaskProgressEvent event = task.getTaskProgressIndicator().getLastProgressEvent();
        long progress = event == null ? 0L : event.getTaskProgress();
        TaskStatus taskStatus = new TaskStatus(progress);
        return Response.ok((Object)taskStatus).cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @Path(value="{id}")
    public Response deleteMigrationStatus(@PathParam(value="id") long id) {
        ApplicationUser user = this.authCtx.getLoggedInUser();
        if (!this.permissionManager.hasPermission(0, user)) {
            return MigrationStatusResource.forbidden();
        }
        TaskDescriptor task = this.taskManager.getTask(Long.valueOf(id));
        if (task == null) {
            return MigrationStatusResource.notFound();
        }
        String taskOwner = task.getUserName();
        if (taskOwner != null && !taskOwner.equals(user.getName())) {
            return MigrationStatusResource.forbidden();
        }
        this.taskManager.removeTask(Long.valueOf(id));
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    private static Response notFound() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
    }

    private static Response forbidden() {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).cacheControl(CacheControl.never()).build();
    }

    @JsonAutoDetect
    public static class TaskStatus {
        private final boolean finished;
        private final Long progress;
        private final Boolean successful;
        private final ErrorCollection errorCollection;
        private final Integer numberOfFailedIssues;
        private final List<String> failedIssues;

        public TaskStatus(WorkflowMigrationResult result) {
            this.finished = true;
            this.progress = null;
            this.successful = result.getResult() == 0;
            this.errorCollection = ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)result.getErrorCollection());
            this.numberOfFailedIssues = result.getNumberOfFailedIssues();
            this.failedIssues = ImmutableList.copyOf(result.getFailedIssues().values());
        }

        public TaskStatus(long progress) {
            this.finished = false;
            this.progress = progress;
            this.successful = null;
            this.errorCollection = null;
            this.numberOfFailedIssues = null;
            this.failedIssues = null;
        }

        public Boolean isSuccessful() {
            return this.successful;
        }

        public ErrorCollection getErrorCollection() {
            return this.errorCollection;
        }

        public Integer getNumberOfFailedIssues() {
            return this.numberOfFailedIssues;
        }

        public List<String> getFailedIssues() {
            return this.failedIssues;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public Long getProgress() {
            return this.progress;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskStatus that = (TaskStatus)o;
            if (this.finished != that.finished) {
                return false;
            }
            if (this.errorCollection != null ? !this.errorCollection.equals((Object)that.errorCollection) : that.errorCollection != null) {
                return false;
            }
            if (this.failedIssues != null ? !this.failedIssues.equals(that.failedIssues) : that.failedIssues != null) {
                return false;
            }
            if (this.numberOfFailedIssues != null ? !this.numberOfFailedIssues.equals(that.numberOfFailedIssues) : that.numberOfFailedIssues != null) {
                return false;
            }
            if (this.progress != null ? !this.progress.equals(that.progress) : that.progress != null) {
                return false;
            }
            return !(this.successful != null ? !this.successful.equals(that.successful) : that.successful != null);
        }

        public int hashCode() {
            int result = this.finished ? 1 : 0;
            result = 31 * result + (this.progress != null ? this.progress.hashCode() : 0);
            result = 31 * result + (this.successful != null ? this.successful.hashCode() : 0);
            result = 31 * result + (this.errorCollection != null ? this.errorCollection.hashCode() : 0);
            result = 31 * result + (this.numberOfFailedIssues != null ? this.numberOfFailedIssues.hashCode() : 0);
            result = 31 * result + (this.failedIssues != null ? this.failedIssues.hashCode() : 0);
            return result;
        }
    }
}

