/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.rest.project;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.projectconfig.beans.ProjectContext;
import com.atlassian.jira.projectconfig.issuetypes.workflow.IssueTypeConfigWorkflowHelper;
import com.atlassian.jira.projectconfig.rest.Responses;
import com.atlassian.jira.projectconfig.rest.beans.SharedByData;
import com.atlassian.jira.projectconfig.util.ProjectContextLocator;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonProperty;

@Path(value="issuetype/{project}/{issuetype}/workflow")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IssueTypeConfigWorkflowResource {
    private final IssueTypeConfigWorkflowHelper workflowHelper;
    private final ProjectContextLocator projectContextLocator;

    public IssueTypeConfigWorkflowResource(IssueTypeConfigWorkflowHelper workflowHelper, ProjectContextLocator projectContextLocator) {
        this.workflowHelper = workflowHelper;
        this.projectContextLocator = projectContextLocator;
    }

    @GET
    public Response getWorkflowData(@PathParam(value="project") String projectKey, @PathParam(value="issuetype") long issueTypeId) {
        ServiceOutcome<ProjectContext> context = this.projectContextLocator.getContext(projectKey, issueTypeId);
        if (!context.isValid()) {
            return Responses.forOutcome(context);
        }
        return Responses.ok(new WorkflowDetails(this.workflowHelper.getWorkflowData((ProjectContext)context.get())));
    }

    public static class WorkflowDetails
    extends SharedByData {
        @JsonProperty
        private String name;
        @JsonProperty
        private String state;
        @JsonProperty
        private String displayName;
        @JsonProperty
        private Long updatedDate;
        @JsonProperty
        private boolean isDraftWithChanges;

        WorkflowDetails(IssueTypeConfigWorkflowHelper.WorkflowResult workflowResult) {
            super(workflowResult.getSharedBy());
            this.name = workflowResult.getWorkflow().getName();
            this.displayName = workflowResult.getWorkflow().getDisplayName();
            this.state = workflowResult.getWorkflowState().simpleName();
            this.isDraftWithChanges = workflowResult.isDraftWithChanges();
            Date updatedDate = workflowResult.getWorkflow().getUpdatedDate();
            this.updatedDate = updatedDate != null ? Long.valueOf(updatedDate.getTime()) : null;
        }

        public String getName() {
            return this.name;
        }

        public String getState() {
            return this.state;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Long getUpdatedDate() {
            return this.updatedDate;
        }

        public boolean isDraftWithChanges() {
            return this.isDraftWithChanges;
        }
    }
}

