/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.rest.project;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.projectconfig.beans.ProjectContext;
import com.atlassian.jira.projectconfig.issuetypes.fields.IssueTypeConfigFieldsHelper;
import com.atlassian.jira.projectconfig.rest.Responses;
import com.atlassian.jira.projectconfig.rest.beans.SharedByData;
import com.atlassian.jira.projectconfig.util.ProjectContextLocator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonProperty;

@Path(value="issuetype/{project}/{issuetype}/fields")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IssueTypeConfigFieldsResource {
    private final IssueTypeConfigFieldsHelper fieldsHelper;
    private final ProjectContextLocator projectContextLocator;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public IssueTypeConfigFieldsResource(IssueTypeConfigFieldsHelper fieldsHelper, ProjectContextLocator projectContextLocator, JiraAuthenticationContext jiraAuthenticationContext) {
        this.fieldsHelper = fieldsHelper;
        this.projectContextLocator = projectContextLocator;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @GET
    public Response getFieldsData(@PathParam(value="project") String projectKey, @PathParam(value="issuetype") long issueTypeId) {
        ServiceOutcome<ProjectContext> context = this.projectContextLocator.getContext(projectKey, issueTypeId);
        if (!context.isValid()) {
            return Responses.forOutcome(context);
        }
        return Responses.ok(new FieldsDetails(this.fieldsHelper.getFieldsData((ProjectContext)context.get(), this.jiraAuthenticationContext.getLoggedInUser())));
    }

    public static class FieldsDetails {
        @JsonProperty
        private final FieldsScreenDetails viewScreen;

        private FieldsDetails(IssueTypeConfigFieldsHelper.FieldsResult fieldsResult) {
            this.viewScreen = new FieldsScreenDetails(fieldsResult.getFieldScreenView());
        }

        public FieldsScreenDetails getViewScreen() {
            return this.viewScreen;
        }
    }

    public static class FieldsScreenDetails
    extends SharedByData {
        @JsonProperty
        private final long screenId;
        @JsonProperty
        private final String screenName;
        @JsonProperty
        private final Boolean canEdit;
        @JsonProperty
        private String state;

        private FieldsScreenDetails(IssueTypeConfigFieldsHelper.FieldsScreenResult screenResult) {
            super(screenResult.getSharedBy());
            this.screenId = screenResult.getScreen().getId();
            this.screenName = screenResult.getScreen().getName();
            this.canEdit = screenResult.getCanEdit();
            this.state = screenResult.getFieldsState().simpleName();
        }

        public long getScreenId() {
            return this.screenId;
        }

        public String getScreenName() {
            return this.screenName;
        }

        public Boolean getCanEdit() {
            return this.canEdit;
        }

        public String getState() {
            return this.state;
        }
    }
}

