/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.rest.global;

import com.atlassian.jira.bc.customfield.CustomFieldService;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.CustomFieldTypeCategory;
import com.atlassian.jira.issue.customfields.config.item.SettableOptionsConfigItem;
import com.atlassian.jira.issue.customfields.impl.CascadingSelectCFType;
import com.atlassian.jira.projectconfig.rest.AdminRequired;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonProperty;

@AdminRequired
@WebSudoRequired
@Path(value="customfieldtypes")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CustomFieldTypesResource {
    private static final String RESOURCE_TYPE = "download";
    private final CustomFieldService customFieldService;
    private final CustomFieldManager customFieldManager;
    private final JiraAuthenticationContext jac;
    private final WebResourceUrlProvider provider;

    public CustomFieldTypesResource(CustomFieldService customFieldService, CustomFieldManager customFieldManager, JiraAuthenticationContext jac, WebResourceUrlProvider provider) {
        this.customFieldService = customFieldService;
        this.customFieldManager = customFieldManager;
        this.jac = jac;
        this.provider = provider;
    }

    @GET
    public Response getTypes() {
        ApplicationUser user = this.jac.getUser();
        ArrayList fieldTypeBeans = Lists.newArrayList();
        I18nHelper i18nHelper = this.jac.getI18nHelper();
        for (CustomFieldType fieldType : this.customFieldService.getCustomFieldTypesForUser(user)) {
            ResponseBean.CustomFieldTypeBean bean = new ResponseBean.CustomFieldTypeBean(fieldType);
            bean.setManagedDescription(i18nHelper.getText(fieldType.getDescriptor().getManagedDescriptionKey()));
            bean.setPreviewImageUrl(this.getThumbUrl(fieldType));
            bean.setOptions(this.hasOptions(fieldType));
            bean.setCascading(this.isCascading(fieldType));
            bean.setSearchers(this.getSearchers(fieldType));
            fieldTypeBeans.add(bean);
        }
        return Response.ok((Object)new ResponseBean(fieldTypeBeans, i18nHelper)).cacheControl(CacheControl.never()).build();
    }

    @VisibleForTesting
    boolean isCascading(CustomFieldType<?, ?> type) {
        return type instanceof CascadingSelectCFType;
    }

    @VisibleForTesting
    boolean hasOptions(CustomFieldType<?, ?> type) {
        return Iterables.any((Iterable)type.getConfigurationItemTypes(), (Predicate)Predicates.instanceOf(SettableOptionsConfigItem.class));
    }

    private String getThumbUrl(CustomFieldType<?, ?> fieldType) {
        ResourceDescriptor imageUrl = fieldType.getDescriptor().getResourceDescriptor(RESOURCE_TYPE, "customfieldpreview.png");
        String fieldPreviewImageUrl = null;
        if (imageUrl != null) {
            fieldPreviewImageUrl = this.provider.getStaticPluginResourceUrl((ModuleDescriptor)fieldType.getDescriptor(), "customfieldpreview.png", UrlMode.RELATIVE);
        }
        return fieldPreviewImageUrl;
    }

    private Iterable<String> getSearchers(CustomFieldType<?, ?> type) {
        return Iterables.transform((Iterable)this.customFieldManager.getCustomFieldSearchers(type), (Function)new Function<CustomFieldSearcher, String>(){

            public String apply(CustomFieldSearcher input) {
                return input.getDescriptor().getCompleteKey();
            }
        });
    }

    public static class ResponseBean {
        private final Iterable<CategoryBean> categories;
        private final Iterable<CustomFieldTypeBean> types;

        private ResponseBean(Iterable<CustomFieldTypeBean> types, I18nHelper helper) {
            this.categories = CategoryBean.toBeans(helper);
            this.types = types;
        }

        @JsonProperty
        public Iterable<CategoryBean> getCategories() {
            return this.categories;
        }

        @JsonProperty
        public Iterable<CustomFieldTypeBean> getTypes() {
            return this.types;
        }

        public static class CustomFieldTypeBean {
            private String name;
            private String description;
            private String key;
            private String previewImageUrl;
            private Set<CustomFieldTypeCategory> categories;
            private boolean isManaged;
            private String managedDescription;
            private boolean options;
            private boolean cascading;
            private Iterable<String> searchers;

            private CustomFieldTypeBean(CustomFieldType<?, ?> type) {
                this.name = type.getName();
                this.description = type.getDescription();
                this.key = type.getKey();
                this.categories = type.getDescriptor().getCategories();
                this.isManaged = type.getDescriptor().isTypeManaged();
            }

            public CustomFieldTypeBean setCascading(boolean cascading) {
                this.cascading = cascading;
                return this;
            }

            public CustomFieldTypeBean setManagedDescription(String managedDescription) {
                this.managedDescription = managedDescription;
                return this;
            }

            public CustomFieldTypeBean setOptions(boolean options) {
                this.options = options;
                return this;
            }

            public CustomFieldTypeBean setPreviewImageUrl(String previewImageUrl) {
                this.previewImageUrl = previewImageUrl;
                return this;
            }

            public CustomFieldTypeBean setSearchers(Iterable<String> searchers) {
                this.searchers = searchers;
                return this;
            }

            @JsonProperty
            public String getManagedDescription() {
                return this.managedDescription;
            }

            @JsonProperty(value="isManaged")
            public boolean isManaged() {
                return this.isManaged;
            }

            @JsonProperty
            public String getName() {
                return this.name;
            }

            @JsonProperty
            public String getDescription() {
                return this.description;
            }

            @JsonProperty
            public String getKey() {
                return this.key;
            }

            @JsonProperty
            public String getPreviewImageUrl() {
                return this.previewImageUrl;
            }

            @JsonProperty
            public Set<CustomFieldTypeCategory> getCategories() {
                return this.categories;
            }

            @JsonProperty
            public Iterable<String> getSearchers() {
                return this.searchers;
            }

            @JsonProperty
            public boolean isCascading() {
                return this.cascading;
            }

            @JsonProperty
            public boolean isOptions() {
                return this.options;
            }
        }

        public static class CategoryBean {
            private final String id;
            private final String name;

            private CategoryBean(CustomFieldTypeCategory category, I18nHelper helper) {
                this.id = category.name();
                this.name = helper.getText(category.getNameI18nKey());
            }

            @JsonProperty
            public String getId() {
                return this.id;
            }

            @JsonProperty
            public String getName() {
                return this.name;
            }

            public static Iterable<CategoryBean> toBeans(I18nHelper helper) {
                ArrayList list = Lists.newArrayList();
                for (CustomFieldTypeCategory category : CustomFieldTypeCategory.orderedValues()) {
                    list.add(new CategoryBean(category, helper));
                }
                return Collections.unmodifiableList(list);
            }
        }
    }
}

