/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.rest.global;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.customfield.CustomFieldService;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.manager.OptionsService;
import com.atlassian.jira.issue.customfields.option.SimpleOption;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.projectconfig.rest.AdminRequired;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@AdminRequired
@WebSudoRequired
@Path(value="customfieldoptions")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CustomFieldOptionsResource {
    private final OptionsService optionsService;
    private final CustomFieldService customFieldService;
    private final JiraAuthenticationContext context;

    public CustomFieldOptionsResource(CustomFieldService customFieldManager, OptionsService optionsService, JiraAuthenticationContext context) {
        this.optionsService = optionsService;
        this.customFieldService = customFieldManager;
        this.context = context;
    }

    @Path(value="{customFieldId}")
    @POST
    public Response setOptions(@PathParam(value="customFieldId") String customFieldId, List<Option> request) {
        ServiceOutcome editConfig;
        if (customFieldId == null) {
            return this.badRequest();
        }
        if (request == null) {
            request = Collections.emptyList();
        }
        if (!(editConfig = this.customFieldService.getCustomFieldForEditConfig(this.context.getUser(), customFieldId)).isValid()) {
            return this.buildResponseFrom(editConfig);
        }
        OptionsService.SetOptionParams update = new OptionsService.SetOptionParams().user(this.context.getUser()).customField((CustomField)editConfig.getReturnedValue(), IssueContext.GLOBAL).option(request);
        ServiceOutcome optionsOutcome = this.optionsService.validateSetOptions(update);
        if (!optionsOutcome.isValid()) {
            return this.buildResponseFrom(optionsOutcome);
        }
        return this.buildResponseFrom(this.optionsService.setOptions((OptionsService.SetValidateResult)optionsOutcome.getReturnedValue()));
    }

    private Response buildResponseFrom(ServiceOutcome<?> response) {
        com.atlassian.jira.util.ErrorCollection collection = response.getErrorCollection();
        if (collection.hasAnyErrors()) {
            ErrorCollection.Reason reason = ErrorCollection.Reason.getWorstReason((Collection)collection.getReasons());
            if (reason == null) {
                reason = ErrorCollection.Reason.VALIDATION_FAILED;
            }
            return Response.status((int)reason.getHttpStatusCode()).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)collection)).cacheControl(CacheControl.never()).build();
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControl.never()).build();
    }

    private Response badRequest() {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).build();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Option
    implements SimpleOption<Option> {
        private final String name;
        private final Long id;

        @JsonCreator
        public Option(@JsonProperty(value="id") Long id, @JsonProperty(value="name") String name) {
            this.id = id;
            this.name = name;
        }

        public Long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Long getOptionId() {
            return this.getId();
        }

        public String getValue() {
            return this.getName();
        }

        @Nonnull
        public List<Option> getChildOptions() {
            return Collections.emptyList();
        }
    }
}

