/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.rest.beans;

import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.projectconfig.rest.beans.SimpleRestProject;
import com.atlassian.jira.projectconfig.shared.SharedIssueTypeWorkflowData;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class SharedByData {
    private final List<SimpleRestProject> sharedWithProjects;
    private final List<String> sharedWithIssueTypes;
    private final long totalProjectsCount;

    public SharedByData(List<SimpleRestProject> projects, long totalProjectsCount) {
        this.sharedWithProjects = projects;
        this.sharedWithIssueTypes = Collections.emptyList();
        this.totalProjectsCount = totalProjectsCount;
    }

    public SharedByData(SharedIssueTypeWorkflowData sharedIssueTypeWorkflowData) {
        this.sharedWithProjects = sharedIssueTypeWorkflowData.getProjects().stream().map(SimpleRestProject::fullProject).collect(Collectors.toList());
        this.sharedWithIssueTypes = sharedIssueTypeWorkflowData.getIssueTypes().stream().map(IssueConstant::getId).collect(Collectors.toList());
        this.totalProjectsCount = sharedIssueTypeWorkflowData.getTotalProjectsCount();
    }

    public List<SimpleRestProject> getSharedWithProjects() {
        return this.sharedWithProjects;
    }

    public List<String> getSharedWithIssueTypes() {
        return this.sharedWithIssueTypes;
    }

    public long getHiddenProjectsCount() {
        return this.totalProjectsCount - (long)this.sharedWithProjects.size();
    }

    public long getTotalProjectsCount() {
        return this.totalProjectsCount;
    }
}

