/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.rest;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.util.ErrorCollection;
import java.util.Collection;
import javax.ws.rs.core.Response;

public final class Responses {
    private Responses() {
    }

    public static Response ok(Object bean) {
        return Responses.build(Response.ok((Object)bean));
    }

    public static Response forOutcome(ServiceOutcome<?> outcome) {
        if (outcome.isValid()) {
            return Responses.ok(outcome.get());
        }
        return Responses.forCollection(outcome.getErrorCollection());
    }

    private static Response forCollection(ErrorCollection collection) {
        return Responses.forCollection(collection, ErrorCollection.Reason.SERVER_ERROR);
    }

    private static Response forCollection(ErrorCollection collection, ErrorCollection.Reason defaultReason) {
        if (!collection.hasAnyErrors()) {
            throw new IllegalArgumentException("collection has no errors.");
        }
        if (defaultReason == null) {
            throw new IllegalArgumentException("defaultReason is null");
        }
        ErrorCollection.Reason worstReason = ErrorCollection.Reason.getWorstReason((Collection)collection.getReasons());
        if (worstReason == null) {
            worstReason = defaultReason;
        }
        return Responses.build(Response.status((int)worstReason.getHttpStatusCode()).entity((Object)com.atlassian.jira.rest.api.util.ErrorCollection.of((ErrorCollection)collection)));
    }

    private static Response build(Response.ResponseBuilder builder) {
        return builder.cacheControl(CacheControl.never()).build();
    }
}

