/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.order;

import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.IssueConstants;
import com.atlassian.jira.projectconfig.beans.NamedDefault;
import com.atlassian.jira.projectconfig.beans.SimpleIssueType;
import com.atlassian.jira.projectconfig.order.ChainedComparator;
import com.atlassian.jira.projectconfig.order.NamedDefaultComparator;
import com.atlassian.jira.projectconfig.order.OrderFactory;
import com.atlassian.jira.projectconfig.order.SimpleIssueTypeComparator;
import com.atlassian.jira.projectconfig.util.ProjectConfigRequestCache;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.collect.Ordering;
import java.text.Collator;
import java.util.Comparator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultOrderFactory
implements OrderFactory {
    private static final String KEY_STRING_COMPARATOR = "stringComparator";
    private static final String KEY_ISSUE_CONSTANT_COMPARATOR = "namedObjectComparator";
    public static final String KEY_ISSUE_TYPE_COMPARATOR = "issueTypeComparator";
    private final ProjectConfigRequestCache cache;
    private final JiraAuthenticationContext context;

    @Autowired
    public DefaultOrderFactory(ProjectConfigRequestCache cache, JiraAuthenticationContext context) {
        this.cache = cache;
        this.context = context;
    }

    @Override
    public Comparator<String> createStringComparator() {
        ChainedComparator comparator = (ChainedComparator)this.cache.get(KEY_STRING_COMPARATOR);
        if (comparator == null) {
            Collator primary = this.createForCurrentUser();
            primary.setStrength(1);
            Collator secondary = this.createForCurrentUser();
            secondary.setStrength(2);
            comparator = ChainedComparator.of(primary, secondary);
            this.cache.put(KEY_STRING_COMPARATOR, comparator);
        }
        return comparator;
    }

    @Override
    public Comparator<NamedDefault> createNamedDefaultComparator() {
        Comparator comparator = (Comparator)this.cache.get(KEY_ISSUE_CONSTANT_COMPARATOR);
        if (comparator == null) {
            comparator = new NamedDefaultComparator(this.createStringComparator());
            this.cache.put(KEY_ISSUE_CONSTANT_COMPARATOR, comparator);
        }
        return comparator;
    }

    @Override
    public Comparator<SimpleIssueType> createIssueTypeComparator() {
        Comparator comparator = (Comparator)this.cache.get(KEY_ISSUE_TYPE_COMPARATOR);
        if (comparator == null) {
            comparator = new SimpleIssueTypeComparator(this.createStringComparator());
            this.cache.put(KEY_ISSUE_TYPE_COMPARATOR, comparator);
        }
        return comparator;
    }

    @Override
    public Ordering<IssueConstant> createTranslatedNameOrder() {
        return Ordering.from(this.createStringComparator()).onResultOf(IssueConstants.getTranslatedNameFunc());
    }

    private Collator createForCurrentUser() {
        return Collator.getInstance(this.context.getLocale());
    }
}

