/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.listener;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.user.LogoutEvent;
import com.atlassian.jira.user.UserPropertyManager;
import com.opensymphony.module.propertyset.PropertySet;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LogoutEventListener
implements InitializingBean,
DisposableBean {
    private final EventPublisher eventPublisher;
    private final UserPropertyManager userPropertyManager;

    @Autowired
    public LogoutEventListener(EventPublisher eventPublisher, UserPropertyManager userPropertyManager) {
        this.eventPublisher = eventPublisher;
        this.userPropertyManager = userPropertyManager;
    }

    @EventListener
    public void onLogoutEvent(LogoutEvent logoutEvent) {
        if (logoutEvent != null && logoutEvent.getUser() != null) {
            PropertySet userProperties = this.userPropertyManager.getPropertySet(logoutEvent.getUser());
            userProperties.remove("atl.jira.admin.current.project");
            userProperties.remove("atl.jira.admin.current.project.tab");
            userProperties.remove("atl.jira.admin.current.project.return.url");
        }
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }
}

