/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.issuetypes.workflow;

import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.beans.ProjectContext;
import com.atlassian.jira.projectconfig.beans.ProjectWorkflowContext;
import com.atlassian.jira.projectconfig.issuetypes.workflow.IssueTypeConfigWorkflowHelper;
import com.atlassian.jira.projectconfig.shared.SharedEntitiesHelper;
import com.atlassian.jira.projectconfig.shared.SharedIssueTypeWorkflowData;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import java.util.Date;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultIssueTypeConfigWorkflowHelper
implements IssueTypeConfigWorkflowHelper {
    private final JiraAuthenticationContext context;
    private final PermissionManager permissionManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final WorkflowManager workflowManager;
    private final WorkflowService workflowService;
    private final SharedEntitiesHelper sharedHelper;

    @Autowired
    public DefaultIssueTypeConfigWorkflowHelper(JiraAuthenticationContext context, PermissionManager permissionManager, WorkflowSchemeManager workflowSchemeManager, WorkflowManager workflowManager, WorkflowService workflowService, SharedEntitiesHelper sharedHelper) {
        this.context = context;
        this.permissionManager = permissionManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.workflowManager = workflowManager;
        this.workflowService = workflowService;
        this.sharedHelper = sharedHelper;
    }

    @Override
    @Nonnull
    public IssueTypeConfigWorkflowHelper.WorkflowResult getWorkflowData(@Nonnull ProjectContext issueContext) {
        Project project = issueContext.getProject();
        JiraWorkflow jiraWorkflow = this.workflowManager.getWorkflow(project.getId(), issueContext.getType().getId());
        return this.getWorkflowData(project, jiraWorkflow);
    }

    @Override
    @Nonnull
    public IssueTypeConfigWorkflowHelper.WorkflowResult getWorkflowData(@Nonnull ProjectWorkflowContext context) {
        return this.getWorkflowData(context.getProject(), context.getWorkflow());
    }

    private IssueTypeConfigWorkflowHelper.WorkflowResult getWorkflowData(@Nonnull Project project, @Nonnull JiraWorkflow jiraWorkflow) {
        IssueTypeConfigWorkflowHelper.WorkflowState workflowState = this.getWorkflowState(project, jiraWorkflow);
        SharedIssueTypeWorkflowData usedBy = this.sharedHelper.getSharedData(project, jiraWorkflow.getName());
        return new IssueTypeConfigWorkflowHelper.WorkflowResult(jiraWorkflow, workflowState, this.isDraftWorkflowWithChanges(jiraWorkflow), usedBy);
    }

    private boolean isDraftWorkflowWithChanges(@Nonnull JiraWorkflow jiraWorkflow) {
        JiraWorkflow draftWorkflow = this.workflowManager.getDraftWorkflow(jiraWorkflow.getName());
        if (draftWorkflow != null) {
            Date draftWorkflowUpdatedDate = draftWorkflow.getUpdatedDate();
            return draftWorkflowUpdatedDate != null && !draftWorkflowUpdatedDate.equals(jiraWorkflow.getUpdatedDate());
        }
        return false;
    }

    private IssueTypeConfigWorkflowHelper.WorkflowState getWorkflowState(Project project, JiraWorkflow workflow) {
        boolean notGlobalAdmin;
        boolean bl = notGlobalAdmin = !this.permissionManager.hasPermission(0, this.context.getUser());
        if (notGlobalAdmin) {
            WorkflowService.WorkflowPermission workflowPermission = this.workflowService.getWorkflowPermission(this.context.getLoggedInUser(), workflow);
            switch (workflowPermission) {
                case NO_PERMISSION: {
                    return IssueTypeConfigWorkflowHelper.WorkflowState.NO_PERMISSION;
                }
                case EDITABLE: {
                    return IssueTypeConfigWorkflowHelper.WorkflowState.EDITABLE_DELEGATED;
                }
                case SYSTEM_WORKFLOW: {
                    return IssueTypeConfigWorkflowHelper.WorkflowState.READ_ONLY_DELEGATED_SYSTEM;
                }
            }
            return IssueTypeConfigWorkflowHelper.WorkflowState.READ_ONLY_DELEGATED_SHARED;
        }
        if (this.workflowSchemeManager.isUsingDefaultScheme(project)) {
            return IssueTypeConfigWorkflowHelper.WorkflowState.MIGRATE;
        }
        if (workflow.isSystemWorkflow()) {
            return IssueTypeConfigWorkflowHelper.WorkflowState.READ_ONLY_DELEGATED_SYSTEM;
        }
        return IssueTypeConfigWorkflowHelper.WorkflowState.EDITABLE;
    }
}

