/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.issuetypes.fields;

import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.ProjectFieldScreenHelper;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.operation.ScreenableIssueOperation;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.beans.ProjectContext;
import com.atlassian.jira.projectconfig.issuetypes.fields.IssueTypeConfigFieldsHelper;
import com.atlassian.jira.projectconfig.order.OrderFactory;
import com.atlassian.jira.projectconfig.shared.SharedEntitiesHelper;
import com.atlassian.jira.projectconfig.shared.SharedIssueTypeWorkflowData;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultIssueTypeConfigFieldsHelper
implements IssueTypeConfigFieldsHelper {
    private final IssueTypeScreenSchemeManager issueTypeScreenManager;
    private final ProjectFieldScreenHelper projectFieldScreenHelper;
    private final OrderFactory orderFactory;
    private final SharedEntitiesHelper sharedEntitiesHelper;
    private GlobalPermissionManager globalPermissionManager;

    @Autowired
    public DefaultIssueTypeConfigFieldsHelper(@ComponentImport IssueTypeScreenSchemeManager issueTypeScreenManager, @ComponentImport ProjectFieldScreenHelper projectFieldScreenHelper, OrderFactory orderFactory, SharedEntitiesHelper sharedEntitiesHelper, GlobalPermissionManager globalPermissionManager) {
        this.issueTypeScreenManager = issueTypeScreenManager;
        this.projectFieldScreenHelper = projectFieldScreenHelper;
        this.orderFactory = orderFactory;
        this.sharedEntitiesHelper = sharedEntitiesHelper;
        this.globalPermissionManager = globalPermissionManager;
    }

    @Override
    @Nonnull
    public IssueTypeConfigFieldsHelper.FieldsResult getFieldsData(@Nonnull ProjectContext context, ApplicationUser user) {
        IssueTypeConfigFieldsHelper.FieldsScreenResult viewScreen = this.getScreenResultForOperation(context, IssueOperations.VIEW_ISSUE_OPERATION, user);
        return new IssueTypeConfigFieldsHelper.FieldsResult(viewScreen);
    }

    private IssueTypeConfigFieldsHelper.FieldsScreenResult getScreenResultForOperation(ProjectContext context, ScreenableIssueOperation operation, ApplicationUser user) {
        FieldScreen screen = this.getFieldScreen(context.getProject(), context.getType(), operation);
        boolean hasEditPermission = this.projectFieldScreenHelper.canUserEditScreen(user, screen);
        List<IssueType> issueTypes = this.getIssueTypesSharingScreen(screen, context);
        SharedIssueTypeWorkflowData sharedBy = this.sharedEntitiesHelper.getSharedData(screen, issueTypes);
        ProjectFieldScreenHelper.FieldsScreenPermission fieldState = this.projectFieldScreenHelper.getUserEditScreenPermission(user, screen);
        return new IssueTypeConfigFieldsHelper.FieldsScreenResult(screen, sharedBy, hasEditPermission, fieldState);
    }

    private FieldScreen getFieldScreen(Project project, IssueType type, ScreenableIssueOperation operation) {
        return this.issueTypeScreenManager.getIssueTypeScreenScheme(project).getEffectiveFieldScreenScheme(type).getFieldScreen((IssueOperation)operation);
    }

    private List<Project> getProjectsSharingScreen(FieldScreen fieldScreen) {
        return this.projectFieldScreenHelper.getAllProjectsForFieldScreen(fieldScreen);
    }

    private List<IssueType> getIssueTypesSharingScreen(FieldScreen fieldScreen, ProjectContext context) {
        Project project = context.getProject();
        Long currentViewId = fieldScreen.getId();
        List result = project.getIssueTypes().stream().filter(otherIssueType -> {
            FieldScreen otherFieldScreen = this.getFieldScreen(project, (IssueType)otherIssueType, IssueOperations.VIEW_ISSUE_OPERATION);
            return currentViewId.equals(otherFieldScreen.getId());
        }).collect(Collectors.toList());
        return this.orderFactory.createTranslatedNameOrder().immutableSortedCopy(result);
    }
}

