/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.fields;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.operation.ScreenableIssueOperation;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ScreenFinder {
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;

    @Autowired
    public ScreenFinder(IssueTypeScreenSchemeManager issueTypeScreenSchemeManager) {
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
    }

    @Nonnull
    public Iterable<FieldScreen> getIssueScreens(@Nonnull Issue issue) {
        FieldScreenScheme fieldScreenScheme = this.issueTypeScreenSchemeManager.getFieldScreenScheme(issue);
        HashMap screens = Maps.newHashMap();
        for (ScreenableIssueOperation issueOperation : IssueOperations.getIssueOperations()) {
            FieldScreen fieldScreen = fieldScreenScheme.getFieldScreen((IssueOperation)issueOperation);
            screens.put(fieldScreen.getId(), fieldScreen);
        }
        return Collections.unmodifiableCollection(screens.values());
    }
}

