/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.fields;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.issue.fields.screen.ProjectFieldScreenHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.fields.ScreenFinder;
import com.atlassian.jira.projectconfig.util.Projects;
import com.atlassian.jira.util.lang.Pair;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueFields {
    private static final Logger log = Logger.getLogger(IssueFields.class);
    private final ScreenFinder screenFinder;
    private final ProjectFieldScreenHelper screenHelper;
    private final CustomFieldManager fieldManager;
    private final FieldLayoutManager fieldLayoutManager;

    @Autowired
    public IssueFields(ScreenFinder screenFinder, ProjectFieldScreenHelper screenHelper, CustomFieldManager fieldManager, FieldLayoutManager fieldLayoutManager) {
        this.screenFinder = screenFinder;
        this.screenHelper = screenHelper;
        this.fieldManager = fieldManager;
        this.fieldLayoutManager = fieldLayoutManager;
    }

    public void addFieldToIssueScreens(Field field, Issue issue) {
        for (FieldScreen screen : this.screenFinder.getIssueScreens(issue)) {
            if (screen.containsField(field.getId())) continue;
            FieldScreenTab firstTab = (FieldScreenTab)Iterables.getFirst((Iterable)screen.getTabs(), null);
            if (firstTab == null) {
                log.debug((Object)String.format("Unable to add field %s to screen for issue %s. Screen has no tab.", field.getId(), issue.getKey()));
                continue;
            }
            firstTab.addFieldScreenLayoutItem(field.getId());
        }
    }

    public Iterable<Project> getAffectedProjects(Issue issue) {
        TreeSet projects = Sets.newTreeSet(Projects.nameOrder());
        for (FieldScreen fieldScreen : this.screenFinder.getIssueScreens(issue)) {
            projects.addAll(this.screenHelper.getProjectsForFieldScreen(fieldScreen));
        }
        return Collections.unmodifiableSet(projects);
    }

    public Iterable<OrderableField> getAllCustomFields(Issue issue) {
        ArrayList allOrderableFields = new ArrayList(this.fieldManager.getCustomFieldObjects(issue));
        FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(issue);
        ArrayList visibleFields = Lists.newArrayList();
        for (OrderableField field : allOrderableFields) {
            FieldLayoutItem fieldLayoutItem = fieldLayout.getFieldLayoutItem(field);
            if (fieldLayoutItem != null && fieldLayoutItem.isHidden()) continue;
            visibleFields.add(field);
        }
        Collections.sort(visibleFields);
        return Collections.unmodifiableCollection(visibleFields);
    }

    public Iterable<Pair<OrderableField, Boolean>> getAllCustomFieldsWithOnAllScreensFlag(Issue issue) {
        Iterable<OrderableField> customFields = this.getAllCustomFields(issue);
        Iterable<FieldScreen> screens = this.screenFinder.getIssueScreens(issue);
        HashSet fieldsWithFlags = Sets.newHashSet();
        for (OrderableField field : customFields) {
            FieldScreen fieldScreen;
            boolean onAScreen = true;
            Iterator<FieldScreen> iterator = screens.iterator();
            while (iterator.hasNext() && (onAScreen = (fieldScreen = iterator.next()).containsField(field.getId()))) {
            }
            fieldsWithFlags.add(Pair.nicePairOf((Object)field, (Object)onAScreen));
        }
        return fieldsWithFlags;
    }
}

