/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.discover;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.projectconfig.discover.events.EditWorkflowDiscoverShow;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EditWorkflowDiscoverHelper {
    public static final String EDIT_WORKFLOW_DISCOVER_DIALOG_SHOWN_USER_PROPERTY = "jira.projectconfig.projectadmin.discover.dialog";
    public static final String MARK_SEEN = "seen";
    public static final String PROJECT_CONFIG_WORKFLOWS_DISCOVERY_HELP_URL = "project.config.discovery.workflows";
    public static final String PROJECT_CONFIG_ADMINISTRATION_DISCOVERY_HELP_URL = "project.config.discovery.administration";
    public static final String PROJECT_CONFIG_SCREENS_DISCOVERY_HELP_URL = "project.config.discovery.screens";
    private final HelpUrls helpUrls;
    private final UserPreferencesManager userPreferencesManager;
    private final EventPublisher eventPublisher;

    @Autowired
    public EditWorkflowDiscoverHelper(@ComponentImport HelpUrls helpUrls, @ComponentImport UserPreferencesManager userPreferencesManager, @ComponentImport EventPublisher eventPublisher) {
        this.helpUrls = helpUrls;
        this.userPreferencesManager = userPreferencesManager;
        this.eventPublisher = eventPublisher;
    }

    public boolean shouldShowEditWorkflowDiscover(ApplicationUser user) {
        boolean shouldShow;
        ExtendedPreferences preferences = this.userPreferencesManager.getExtendedPreferences(user);
        boolean bl = shouldShow = !MARK_SEEN.equals(preferences.getString(EDIT_WORKFLOW_DISCOVER_DIALOG_SHOWN_USER_PROPERTY));
        if (shouldShow) {
            this.eventPublisher.publish((Object)new EditWorkflowDiscoverShow());
        }
        return shouldShow;
    }

    public HelpUrl getWorkflowsHelpUrl() {
        return this.helpUrls.getUrl(PROJECT_CONFIG_WORKFLOWS_DISCOVERY_HELP_URL);
    }

    public HelpUrl getScreensHelpUrl() {
        return this.helpUrls.getUrl(PROJECT_CONFIG_SCREENS_DISCOVERY_HELP_URL);
    }

    public HelpUrl getAdministrationHelpUrl() {
        return this.helpUrls.getUrl(PROJECT_CONFIG_ADMINISTRATION_DISCOVERY_HELP_URL);
    }
}

