/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.dataproviders;

import com.atlassian.fugue.Either;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.management.ManagedPermissionSchemeHelper;
import com.atlassian.jira.permission.management.beans.ProjectPermissionSchemeBean;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class PermissionsDataProvider {
    private final ManagedPermissionSchemeHelper managedPermission;
    private final PermissionSchemeManager permissionSchemeManager;

    @Inject
    public PermissionsDataProvider(@ComponentImport ManagedPermissionSchemeHelper managedPermission, @ComponentImport PermissionSchemeManager permissionSchemeManager) {
        this.managedPermission = managedPermission;
        this.permissionSchemeManager = permissionSchemeManager;
    }

    @Nullable
    public ProjectPermissionSchemeBean getProjectPermissionSchemeBean(@Nullable ApplicationUser user, @Nullable Project project) {
        if (user == null || project == null) {
            return null;
        }
        Long schemeId = this.permissionSchemeManager.getSchemeIdFor(project);
        Either outcome = this.managedPermission.getManagedPermissionScheme(user, schemeId);
        return outcome.isRight() ? (ProjectPermissionSchemeBean)outcome.right().get() : null;
    }
}

