/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderUtils;
import com.atlassian.jira.projectconfig.discover.EditWorkflowDiscoverHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.util.collect.CompositeMap;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.migration.WorkflowSchemeMigrationTaskAccessor;
import com.atlassian.plugin.PluginParseException;
import java.util.Map;

public class WorkflowContextProvider
implements CacheableContextProvider {
    private final ContextProviderUtils contextProviderUtils;
    private final WorkflowSchemeMigrationTaskAccessor taskAccessor;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final EditWorkflowDiscoverHelper editWorkflowDiscoverHelper;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public WorkflowContextProvider(ContextProviderUtils contextProviderUtils, WorkflowSchemeMigrationTaskAccessor taskAccessor, WorkflowSchemeManager workflowSchemeManager, EditWorkflowDiscoverHelper editWorkflowDiscoverHelper, JiraAuthenticationContext jiraAuthenticationContext) {
        this.contextProviderUtils = contextProviderUtils;
        this.taskAccessor = taskAccessor;
        this.workflowSchemeManager = workflowSchemeManager;
        this.editWorkflowDiscoverHelper = editWorkflowDiscoverHelper;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    private AssignableWorkflowScheme getWorkflowScheme() {
        return this.workflowSchemeManager.getWorkflowSchemeObj(this.contextProviderUtils.getProject());
    }

    private boolean hasDraft() {
        return this.workflowSchemeManager.hasDraft(this.getWorkflowScheme());
    }

    private boolean isShared() {
        return this.workflowSchemeManager.getProjectsUsing(this.getWorkflowScheme()).size() > 1;
    }

    private boolean isDefault() {
        return this.getWorkflowScheme().isDefault();
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Project project = this.contextProviderUtils.getProject();
        MapBuilder contextBuilder = MapBuilder.newBuilder();
        contextBuilder.add((Object)"hasDraft", (Object)this.hasDraft());
        contextBuilder.add((Object)"isShared", (Object)this.isShared());
        contextBuilder.add((Object)"isDefault", (Object)this.isDefault());
        TaskDescriptor taskDescriptor = this.taskAccessor.getActive(project);
        if (taskDescriptor != null) {
            contextBuilder.add((Object)"projectMigration", (Object)true);
        } else {
            taskDescriptor = this.taskAccessor.getActive((WorkflowScheme)this.getWorkflowScheme());
            if (taskDescriptor != null) {
                contextBuilder.add((Object)"projectMigration", (Object)false);
            }
        }
        if (taskDescriptor != null) {
            contextBuilder.add((Object)"progressURL", (Object)taskDescriptor.getProgressURL());
        }
        boolean discoverShow = this.editWorkflowDiscoverHelper.shouldShowEditWorkflowDiscover(this.jiraAuthenticationContext.getLoggedInUser());
        HelpUrl learnMoreUrl = this.editWorkflowDiscoverHelper.getWorkflowsHelpUrl();
        contextBuilder.add((Object)"showEditWorkflowDiscover", (Object)discoverShow);
        contextBuilder.add((Object)"learnMoreUrl", (Object)learnMoreUrl);
        Map defaults = CompositeMap.of(context, this.contextProviderUtils.getDefaultContext());
        return CompositeMap.of((Map)contextBuilder.toMap(), (Map)defaults);
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return this.getClass().getName();
    }
}

