/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectAssigneeTypes;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginParseException;
import java.util.Map;

public class RolesSummaryPanelContextProvider
implements CacheableContextProvider {
    static final String CONTEXT_PROJECT_LEAD_EXISTS_KEY = "projectLeadExists";
    static final String CONTEXT_PROJECT_LEAD_KEY = "projectLeadHtml";
    static final String CONTEXT_IS_DEFAULT_ASSIGNEE_ASSIGNABLE_KEY = "defaultAssigneeAssignable";
    static final String CONTEXT_DEFAULT_ASSIGNEE_KEY = "defaultAssignee";
    static final String CONTEXT_DEFAULT_ASSIGNEE_EDITABLE = "defaultAssigneeEditable";
    static final String CONTEXT_IS_USER_AVATARS_ENABLED_KEY = "userAvatarsEnabled";
    static final String CONTEXT_LEAD_USER_AVATAR_URL_KEY = "userAvatarUrl";
    private final PermissionManager permissionManager;
    private final UserFormatManager userFormatManager;
    private final UserManager userManager;
    private final AvatarService avatarService;

    public RolesSummaryPanelContextProvider(PermissionManager permissionManager, UserFormatManager userFormatManager, UserManager userManager, AvatarService avatarService) {
        this.permissionManager = permissionManager;
        this.userFormatManager = userFormatManager;
        this.userManager = userManager;
        this.avatarService = avatarService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Project project = (Project)context.get("project");
        String leadUserKey = project.getLeadUserKey();
        ApplicationUser leadUser = this.getUser(leadUserKey);
        String leadUserString = leadUser != null ? this.userFormatManager.formatUser(leadUserKey, "profileLink", "projectLead") : leadUserKey;
        String userAvatarUrl = this.avatarService.getAvatarURL(leadUser, leadUser, Avatar.Size.SMALL).toString();
        return MapBuilder.newBuilder().addAll(context).add((Object)CONTEXT_PROJECT_LEAD_EXISTS_KEY, (Object)(leadUser != null ? 1 : 0)).add((Object)CONTEXT_PROJECT_LEAD_KEY, (Object)leadUserString).add((Object)CONTEXT_IS_DEFAULT_ASSIGNEE_ASSIGNABLE_KEY, (Object)this.isDefaultAssigneeAssignable(project)).add((Object)CONTEXT_DEFAULT_ASSIGNEE_KEY, (Object)this.getPrettyAssigneeTypeString(project.getAssigneeType())).add((Object)CONTEXT_DEFAULT_ASSIGNEE_EDITABLE, (Object)this.isDefaultAssigneeEditable()).add((Object)CONTEXT_LEAD_USER_AVATAR_URL_KEY, (Object)userAvatarUrl).toMap();
    }

    private boolean isDefaultAssigneeEditable() {
        return ProjectAssigneeTypes.getAssigneeTypes().size() > 1;
    }

    private boolean isDefaultAssigneeAssignable(Project project) {
        Long assigneeType = project.getAssigneeType();
        if (assigneeType != null && 2L == assigneeType) {
            ApplicationUser projectLead = project.getProjectLead();
            if (projectLead == null) {
                return false;
            }
            return this.permissionManager.hasPermission(17, project, projectLead);
        }
        return true;
    }

    private ApplicationUser getUser(String userkey) {
        return this.userManager.getUserByKey(userkey);
    }

    String getPrettyAssigneeTypeString(Long assigneeType) {
        return ProjectAssigneeTypes.getPrettyAssigneeType((Long)assigneeType);
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return this.getClass().getName();
    }
}

