/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.ContextProvider;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class ReturnToConfigContextProvider
implements ContextProvider,
Condition {
    static final String VM_CONTEXT_KEY_PROJECT = "project";
    static final String VM_CONTEXT_KEY_BACK_TO_PROJECT_PATH = "backToProjectPath";
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectService projectService;
    private final UserPropertyManager userPropertyManager;

    public ReturnToConfigContextProvider(JiraAuthenticationContext authenticationContext, ProjectService projectService, UserPropertyManager userPropertyManager) {
        this.authenticationContext = authenticationContext;
        this.projectService = projectService;
        this.userPropertyManager = userPropertyManager;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        return StringUtils.isNotBlank((String)this.getCurrentAdminProject());
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        ProjectService.GetProjectResult projectResult;
        MapBuilder contextBuilder = MapBuilder.newBuilder(context);
        String projectKey = this.getCurrentAdminProject();
        if (StringUtils.isNotBlank((String)projectKey) && (projectResult = this.canEditProject(projectKey)).isValid()) {
            Project project = projectResult.getProject();
            contextBuilder.add((Object)VM_CONTEXT_KEY_PROJECT, (Object)project);
        }
        contextBuilder.add((Object)VM_CONTEXT_KEY_BACK_TO_PROJECT_PATH, (Object)this.getUserPropertySet().getString("atl.jira.admin.current.project.return.url"));
        return JiraVelocityUtils.getDefaultVelocityParams((Map)contextBuilder.toMap(), (JiraAuthenticationContext)this.authenticationContext);
    }

    private PropertySet getUserPropertySet() {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        return this.userPropertyManager.getPropertySet(user);
    }

    @Nullable
    private String getCurrentAdminProject() {
        return this.getUserPropertySet().getString("atl.jira.admin.current.project");
    }

    private ProjectService.GetProjectResult canEditProject(String projectKey) {
        return this.projectService.getProjectByKeyForAction(this.authenticationContext.getLoggedInUser(), projectKey, ProjectAction.EDIT_PROJECT_CONFIG);
    }
}

