/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.ProjectFieldScreenHelper;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderUtils;
import com.atlassian.jira.projectconfig.shared.SharedEntitiesHelper;
import com.atlassian.jira.projectconfig.shared.SharedIssueTypeWorkflowData;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class ProjectScreenViewContextProvider
implements ContextProvider {
    private final ContextProviderUtils contextProviderUtils;
    private final SharedEntitiesHelper sharedHelper;
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectFieldScreenHelper projectFieldScreenHelper;

    public ProjectScreenViewContextProvider(ContextProviderUtils contextProviderUtils, SharedEntitiesHelper sharedHelper, JiraAuthenticationContext authenticationContext, ProjectFieldScreenHelper projectFieldScreenHelper) {
        this.contextProviderUtils = contextProviderUtils;
        this.sharedHelper = sharedHelper;
        this.authenticationContext = authenticationContext;
        this.projectFieldScreenHelper = projectFieldScreenHelper;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Map<String, Object> defaultContext = this.contextProviderUtils.getDefaultContext();
        FieldScreen screen = (FieldScreen)context.get("screen");
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        SharedIssueTypeWorkflowData sharedBy = this.sharedHelper.getSharedData(screen);
        String state = this.projectFieldScreenHelper.getUserEditScreenPermission(user, screen).simpleName();
        return ImmutableMap.of((Object)"screenName", (Object)screen.getName(), (Object)"screenId", (Object)screen.getId(), (Object)"sharedBy", (Object)sharedBy, (Object)"state", (Object)state);
    }
}

