/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.PrioritySchemeService;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderUtils;
import com.atlassian.jira.projectconfig.shared.SharedEntitiesHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class ProjectPrioritiesContextProvider
implements CacheableContextProvider {
    private final ContextProviderUtils contextProviderUtils;
    private final PrioritySchemeManager prioritySchemeManager;
    private final SharedEntitiesHelper helper;
    private final FeatureManager featureManager;
    private final PrioritySchemeService prioritySchemeService;

    public ProjectPrioritiesContextProvider(ContextProviderUtils contextProviderUtils, @ComponentImport PrioritySchemeManager prioritySchemeManager, @ComponentImport PrioritySchemeService prioritySchemeService, SharedEntitiesHelper helper, FeatureManager featureManager) {
        this.contextProviderUtils = contextProviderUtils;
        this.prioritySchemeManager = prioritySchemeManager;
        this.prioritySchemeService = prioritySchemeService;
        this.helper = helper;
        this.featureManager = featureManager;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        MapBuilder contextMap = MapBuilder.newBuilder().addAll(context);
        Map<String, Object> defaultContext = this.contextProviderUtils.getDefaultContext();
        contextMap.addAll(defaultContext);
        Project project = this.contextProviderUtils.getProject();
        boolean pppEnabled = this.featureManager.isEnabled(JiraFeatureFlagRegistrar.PRIORITIES_PER_PROJECT);
        if (pppEnabled) {
            FieldConfigScheme scheme = this.prioritySchemeManager.getScheme(project);
            FieldConfig fieldConfig = this.prioritySchemeManager.getFieldConfigForDefaultMapping(scheme);
            Collection priorities = this.prioritySchemeManager.getPrioritiesFromIds((Collection)this.prioritySchemeManager.getOptions(fieldConfig));
            contextMap.add((Object)"schemeName", (Object)scheme.getName());
            contextMap.add((Object)"schemeId", (Object)scheme.getId());
            contextMap.add((Object)"sharedBy", (Object)this.helper.getSharedDataForPriorities(scheme));
            contextMap.add((Object)"defaultScheme", (Object)this.prioritySchemeManager.isDefaultScheme(scheme));
            contextMap.add((Object)"defaultPriority", (Object)this.prioritySchemeManager.getDefaultOption(fieldConfig));
            contextMap.add((Object)"priorities", (Object)priorities);
            contextMap.add((Object)"isSDProject", (Object)this.prioritySchemeService.hasAnyNotPossibleToAssociateProject(Collections.singletonList(project)));
        }
        contextMap.add((Object)"prioritiesPerProjectEnabled", (Object)pppEnabled);
        return contextMap.toMap();
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return MessageFormat.format("{0}:{1}", this.getClass().getName(), this.contextProviderUtils.getProject().getId());
    }
}

