/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.ProjectPermissionSchemeHelper;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderUtils;
import com.atlassian.jira.projectconfig.rest.beans.SharedByData;
import com.atlassian.jira.projectconfig.rest.beans.SimpleRestProject;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginParseException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class ProjectPermissionContextProvider
implements CacheableContextProvider {
    private static final String CONTEXT_SCHEME_SHARED_BY_KEY = "sharedBy";
    private static final String CONTEXT_SCHEME_NAME = "schemeName";
    private static final String CONTEXT_SCHEME_ID = "schemeId";
    private static final String CONTEXT_SCHEME_DESCRIPTION = "schemeDescription";
    private static final String SCHEME_NAME = "name";
    private static final String SCHEME_ID = "id";
    private static final String SCHEME_DESCRIPTION = "description";
    private final PermissionSchemeManager permissionSchemeManager;
    private final ContextProviderUtils contextProviderUtils;
    private final ProjectPermissionSchemeHelper helper;

    public ProjectPermissionContextProvider(PermissionSchemeManager permissionSchemeManager, ContextProviderUtils contextProviderUtils, ProjectPermissionSchemeHelper helper) {
        this.contextProviderUtils = contextProviderUtils;
        this.helper = helper;
        this.permissionSchemeManager = permissionSchemeManager;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        MapBuilder contextMap = MapBuilder.newBuilder().addAll(context);
        Map<String, Object> defaultContext = this.contextProviderUtils.getDefaultContext();
        contextMap.addAll(defaultContext);
        Project project = (Project)defaultContext.get("project");
        GenericValue scheme = this.getProjectPermissionsScheme(project);
        Scheme permissionScheme = this.permissionSchemeManager.getSchemeObject(scheme.getLong(SCHEME_ID));
        List<SimpleRestProject> sharedProjects = this.helper.getSharedProjects(permissionScheme).stream().map(SimpleRestProject::shortProject).collect(Collectors.toList());
        contextMap.add((Object)CONTEXT_SCHEME_SHARED_BY_KEY, (Object)new SharedByData(sharedProjects, this.helper.getAllSharedProjectsCount(permissionScheme)));
        contextMap.add((Object)CONTEXT_SCHEME_NAME, (Object)scheme.getString(SCHEME_NAME));
        contextMap.add((Object)CONTEXT_SCHEME_ID, (Object)scheme.getLong(SCHEME_ID));
        String description = scheme.getString(SCHEME_DESCRIPTION);
        if (StringUtils.isNotBlank((String)description)) {
            contextMap.add((Object)CONTEXT_SCHEME_DESCRIPTION, (Object)description);
        }
        return contextMap.toMap();
    }

    private GenericValue getProjectPermissionsScheme(Project project) {
        try {
            return EntityUtil.getOnly((List)this.permissionSchemeManager.getSchemes(project.getGenericValue()));
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return this.getClass().getName();
    }
}

