/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.ProjectFieldLayoutSchemeHelper;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldConfigurationScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.DefaultHackyFieldRendererRegistry;
import com.atlassian.jira.issue.fields.renderer.HackyFieldRendererRegistry;
import com.atlassian.jira.issue.fields.renderer.HackyRendererType;
import com.atlassian.jira.issue.fields.renderer.RenderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.beans.NamedDefault;
import com.atlassian.jira.projectconfig.beans.SimpleFieldConfigScheme;
import com.atlassian.jira.projectconfig.beans.SimpleIssueType;
import com.atlassian.jira.projectconfig.beans.SimpleIssueTypeImpl;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderUtils;
import com.atlassian.jira.projectconfig.order.OrderFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.CompositeMap;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginParseException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ProjectFieldsContextProvider
implements CacheableContextProvider {
    static final String CONTEXT_FIELDS_SCHEME = "fieldsScheme";
    static final String CONTEXT_FIELD_CONFIGS = "fieldConfigs";
    private final ContextProviderUtils contextProviderUtils;
    private final FieldLayoutManager fieldLayoutManager;
    private final RendererManager rendererManager;
    private final HackyFieldRendererRegistry hackyFieldRendererRegistry;
    private final FieldScreenManager fieldScreenManager;
    private final ProjectFieldLayoutSchemeHelper projectFieldLayoutSchemeHelper;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final OrderFactory orderFactory;
    private final ManagedConfigurationItemService managedConfigurationItemService;
    private final ApplicationUser user;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public ProjectFieldsContextProvider(ContextProviderUtils contextProviderUtils, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, JiraAuthenticationContext jiraAuthenticationContext, FieldScreenManager fieldScreenManager, ProjectFieldLayoutSchemeHelper projectFieldLayoutSchemeHelper, IssueTypeSchemeManager issueTypeSchemeManager, OrderFactory orderFactory, ManagedConfigurationItemService managedConfigurationItemService) {
        this.contextProviderUtils = contextProviderUtils;
        this.fieldLayoutManager = fieldLayoutManager;
        this.rendererManager = rendererManager;
        this.fieldScreenManager = fieldScreenManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.managedConfigurationItemService = managedConfigurationItemService;
        this.user = jiraAuthenticationContext.getLoggedInUser();
        this.hackyFieldRendererRegistry = new DefaultHackyFieldRendererRegistry();
        this.projectFieldLayoutSchemeHelper = projectFieldLayoutSchemeHelper;
        this.orderFactory = orderFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        List<SimpleFieldConfig> fieldConfigs;
        SimpleFieldConfigScheme fieldConfigScheme;
        Map<String, Object> defaultContext = this.contextProviderUtils.getDefaultContext();
        Project project = (Project)defaultContext.get("project");
        List fieldLayoutSchemes = this.fieldLayoutManager.getFieldLayoutSchemes();
        FieldConfigurationScheme fieldConfigurationScheme = this.fieldLayoutManager.getFieldConfigurationScheme(project);
        if (fieldLayoutSchemes == null || fieldLayoutSchemes.size() == 0 || fieldConfigurationScheme == null) {
            fieldConfigScheme = this.getSystemDefaultFieldConfigScheme(project);
            fieldConfigs = this.getSystemDefaultSimpleFieldConfig(project);
        } else {
            fieldConfigScheme = new SimpleFieldConfigScheme(fieldConfigurationScheme, this.getChangeSchemeUrl(project.getId()), this.getEditSchemeUrl(fieldConfigurationScheme.getId()));
            fieldConfigs = this.getSimpleFieldConfigs(project, fieldConfigurationScheme);
        }
        Collections.sort(fieldConfigs, this.orderFactory.createNamedDefaultComparator());
        MapBuilder contextBuilder = MapBuilder.newBuilder();
        contextBuilder.add((Object)CONTEXT_FIELDS_SCHEME, (Object)fieldConfigScheme);
        contextBuilder.add((Object)CONTEXT_FIELD_CONFIGS, fieldConfigs);
        Map defaults = CompositeMap.of(context, defaultContext);
        return CompositeMap.of((Map)contextBuilder.toMap(), (Map)defaults);
    }

    List<SimpleFieldConfig> getSystemDefaultSimpleFieldConfig(Project project) {
        IssueType defaultIssueType = this.issueTypeSchemeManager.getDefaultIssueType(project);
        FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout();
        Multimap activeFieldLayouts = this.projectFieldLayoutSchemeHelper.getProjectsForFieldLayouts(Collections.singleton(fieldLayout));
        TreeSet fieldLayoutSet = Sets.newTreeSet((Iterable)fieldLayout.getFieldLayoutItems());
        Collection issueTypes = project.getIssueTypes();
        ArrayList<SimpleIssueType> simpleIssueTypes = new ArrayList<SimpleIssueType>();
        for (IssueType issueType : issueTypes) {
            simpleIssueTypes.add(new SimpleIssueTypeImpl(issueType, issueType.equals(defaultIssueType)));
        }
        Collections.sort(simpleIssueTypes, this.orderFactory.createIssueTypeComparator());
        return CollectionBuilder.newBuilder((Object[])new SimpleFieldConfig[]{SimpleFieldConfig.getSystemDefaultSimpleFieldConfig(this.getSystemDefaultEditSchemeUrl(), true, activeFieldLayouts.get((Object)fieldLayout), this.getSimpleFieldLayoutItems(fieldLayoutSet), simpleIssueTypes)}).asMutableList();
    }

    List<SimpleFieldConfig> getSimpleFieldConfigs(Project project, FieldConfigurationScheme fieldConfigurationScheme) {
        IssueType defaultIssueType = this.issueTypeSchemeManager.getDefaultIssueType(project);
        Long defaultFieldLayoutId = fieldConfigurationScheme.getFieldLayoutId(null);
        FieldLayout defaultFieldLayout = this.fieldLayoutManager.getFieldLayout();
        if (defaultFieldLayoutId == null) {
            defaultFieldLayoutId = defaultFieldLayout.getId();
        }
        Comparator<FieldLayout> fieldLayoutComparator = this.getFieldLayoutComparator();
        TreeSet fieldLayouts = Sets.newTreeSet(fieldLayoutComparator);
        TreeMap fieldConfigMapping = Maps.newTreeMap(fieldLayoutComparator);
        for (IssueType issueType : project.getIssueTypes()) {
            FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(project, issueType.getId());
            fieldLayouts.add(fieldLayout);
            ArrayList<SimpleIssueTypeImpl> issueTypes = (ArrayList<SimpleIssueTypeImpl>)fieldConfigMapping.get(fieldLayout);
            if (issueTypes == null) {
                issueTypes = new ArrayList<SimpleIssueTypeImpl>();
            }
            issueTypes.add(new SimpleIssueTypeImpl(issueType, issueType.equals(defaultIssueType)));
            fieldConfigMapping.put(fieldLayout, issueTypes);
        }
        Multimap activeFieldLayouts = this.projectFieldLayoutSchemeHelper.getProjectsForFieldLayouts((Set)fieldLayouts);
        LinkedHashSet fieldConfigsWithIssueTypes = Sets.newLinkedHashSet();
        for (FieldLayout fieldLayout : fieldLayouts) {
            SimpleFieldConfig simpleFieldConfig;
            boolean isDefaultFieldConfig;
            List issueTypes = (List)fieldConfigMapping.get(fieldLayout);
            Collections.sort(issueTypes, this.orderFactory.createIssueTypeComparator());
            if (fieldLayout.equals(this.fieldLayoutManager.getFieldLayout())) {
                isDefaultFieldConfig = defaultFieldLayoutId == null;
                simpleFieldConfig = this.createDefaultSimpleFieldConfig(isDefaultFieldConfig, activeFieldLayouts.get((Object)fieldLayout), issueTypes);
            } else {
                isDefaultFieldConfig = fieldLayout.getId().equals(defaultFieldLayoutId);
                simpleFieldConfig = this.createSimpleFieldConfig(fieldLayout, isDefaultFieldConfig, issueTypes, activeFieldLayouts.get((Object)fieldLayout));
            }
            fieldConfigsWithIssueTypes.add(simpleFieldConfig);
        }
        return Lists.newArrayList((Iterable)fieldConfigsWithIssueTypes);
    }

    SimpleFieldConfig createSimpleFieldConfig(FieldLayout fieldLayout, boolean defaultFieldConfig, List<SimpleIssueType> issueTypes, Collection<Project> projects) {
        TreeSet fieldLayoutSet = Sets.newTreeSet((Iterable)fieldLayout.getFieldLayoutItems());
        return new SimpleFieldConfig(fieldLayout, this.getFieldConfigUrl(fieldLayout.getId()), defaultFieldConfig, projects, this.getSimpleFieldLayoutItems(fieldLayoutSet), issueTypes);
    }

    SimpleFieldConfigScheme getSystemDefaultFieldConfigScheme(Project project) {
        return new SimpleFieldConfigScheme(null, this.getI18nHelper().getText("admin.projects.system.default.field.config"), null, this.getChangeSchemeUrl(project.getId()), this.getSystemDefaultEditSchemeUrl());
    }

    String getChangeSchemeUrl(Long id) {
        return this.createUrlBuilder("/secure/admin/SelectFieldLayoutScheme!default.jspa").addParameter("projectId", (Object)id).asUrlString();
    }

    String getEditSchemeUrl(Long id) {
        return this.createUrlBuilder("/secure/admin/ConfigureFieldLayoutScheme.jspa").addParameter("id", (Object)id).asUrlString();
    }

    String getFieldConfigUrl(Long id) {
        return this.createUrlBuilder("/secure/admin/ConfigureFieldLayout!default.jspa").addParameter("id", (Object)id).asUrlString();
    }

    String getSystemDefaultEditSchemeUrl() {
        return this.createUrlBuilder("/secure/admin/ViewIssueFields.jspa").asUrlString();
    }

    String getRendererType(String rendererType) {
        HackyRendererType hackyRendererType = HackyRendererType.fromKey((String)rendererType);
        if (hackyRendererType != null) {
            return this.getI18nHelper().getText(hackyRendererType.getDisplayNameI18nKey());
        }
        return this.rendererManager.getRendererForType(rendererType).getDescriptor().getName();
    }

    private UrlBuilder createUrlBuilder(String operation) {
        return this.contextProviderUtils.createUrlBuilder(operation);
    }

    private SimpleFieldConfig createDefaultSimpleFieldConfig(boolean isDefaultFieldConfig, Collection<Project> projects, List<SimpleIssueType> issueTypes) {
        FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout();
        TreeSet fieldLayoutSet = Sets.newTreeSet((Iterable)fieldLayout.getFieldLayoutItems());
        return SimpleFieldConfig.getSystemDefaultSimpleFieldConfig(this.getSystemDefaultEditSchemeUrl(), isDefaultFieldConfig, projects, this.getSimpleFieldLayoutItems(fieldLayoutSet), issueTypes);
    }

    private Comparator<FieldLayout> getFieldLayoutComparator() {
        return new FieldLayoutComparator(this.orderFactory.createStringComparator());
    }

    private boolean isRenderable(OrderableField field) {
        if (field instanceof RenderableField) {
            RenderableField renderableField = (RenderableField)field;
            boolean isRenderable = renderableField.isRenderable();
            if (!isRenderable && field instanceof CustomField) {
                return this.hackyFieldRendererRegistry.shouldOverrideDefaultRenderers(field);
            }
            return isRenderable;
        }
        return this.hackyFieldRendererRegistry.shouldOverrideDefaultRenderers(field);
    }

    public boolean isFieldManaged(Field field) {
        if (!CustomField.class.isAssignableFrom(field.getClass())) {
            return false;
        }
        CustomField customField = (CustomField)field;
        ManagedConfigurationItem item = this.managedConfigurationItemService.getManagedCustomField(customField);
        return item.isManaged();
    }

    public boolean isFieldLocked(Field field) {
        if (!CustomField.class.isAssignableFrom(field.getClass())) {
            return false;
        }
        CustomField customField = (CustomField)field;
        ManagedConfigurationItem item = this.managedConfigurationItemService.getManagedCustomField(customField);
        if (!item.isManaged()) {
            return false;
        }
        return !this.managedConfigurationItemService.doesUserHavePermission(this.getUser(), item);
    }

    private List<SimpleFieldLayoutItem> getSimpleFieldLayoutItems(Set<FieldLayoutItem> fieldLayoutSet) {
        ArrayList simpleFieldLayoutItems = Lists.newArrayList();
        for (FieldLayoutItem fieldLayoutItem : fieldLayoutSet) {
            if (fieldLayoutItem.isHidden()) continue;
            OrderableField orderableField = fieldLayoutItem.getOrderableField();
            simpleFieldLayoutItems.add(new SimpleFieldLayoutItem(orderableField.getId(), orderableField.getName(), fieldLayoutItem.getFieldDescription(), fieldLayoutItem.isRequired(), this.isFieldManaged((Field)orderableField), this.isFieldLocked((Field)orderableField), this.getRendererType(fieldLayoutItem.getRendererType()), this.isRenderable(orderableField), this.getScreenCount(fieldLayoutItem)));
        }
        return simpleFieldLayoutItems;
    }

    private int getScreenCount(FieldLayoutItem fieldLayoutItem) {
        Collection fieldScreenTabs = this.fieldScreenManager.getFieldScreenTabs(fieldLayoutItem.getOrderableField().getId());
        return fieldScreenTabs.size();
    }

    private I18nHelper getI18nHelper() {
        return this.jiraAuthenticationContext.getI18nHelper();
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return this.getClass().getName();
    }

    public ApplicationUser getUser() {
        return this.user;
    }

    private static class FieldLayoutComparator
    implements Comparator<FieldLayout> {
        private final Comparator<String> collator;

        public FieldLayoutComparator(Comparator<String> collator) {
            this.collator = collator;
        }

        @Override
        public int compare(FieldLayout lhs, FieldLayout rhs) {
            String lhsName = lhs.getName() == null ? "Default Field Configuration" : lhs.getName();
            String rhsName = rhs.getName() == null ? "Default Field Configuration" : rhs.getName();
            return this.collator.compare(lhsName, rhsName);
        }
    }

    public static class SimpleFieldLayoutItem {
        private final String id;
        private final String name;
        private final String descriptionHtml;
        private final boolean required;
        private final boolean managed;
        private final boolean locked;
        private final String rendererType;
        private final boolean renderable;
        private final int screenCount;

        public SimpleFieldLayoutItem(String id, String name, String descriptionHtml, boolean required, boolean managed, boolean locked, String rendererType, boolean isRenderable, int screenCount) {
            this.id = id;
            this.name = name;
            this.descriptionHtml = descriptionHtml;
            this.required = required;
            this.managed = managed;
            this.locked = locked;
            this.rendererType = rendererType;
            this.renderable = isRenderable;
            this.screenCount = screenCount;
        }

        public String getId() {
            return this.id;
        }

        public boolean isRequired() {
            return this.required;
        }

        public boolean isRenderable() {
            return this.renderable;
        }

        public String getRendererType() {
            return this.rendererType;
        }

        public String getName() {
            return this.name;
        }

        public String getDescriptionHtml() {
            return this.descriptionHtml;
        }

        public int getScreenCount() {
            return this.screenCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleFieldLayoutItem that = (SimpleFieldLayoutItem)o;
            if (this.renderable != that.renderable) {
                return false;
            }
            if (this.required != that.required) {
                return false;
            }
            if (this.screenCount != that.screenCount) {
                return false;
            }
            if (this.descriptionHtml != null ? !this.descriptionHtml.equals(that.descriptionHtml) : that.descriptionHtml != null) {
                return false;
            }
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return !(this.rendererType != null ? !this.rendererType.equals(that.rendererType) : that.rendererType != null);
        }

        public int hashCode() {
            int result = this.id != null ? this.id.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.descriptionHtml != null ? this.descriptionHtml.hashCode() : 0);
            result = 31 * result + (this.required ? 1 : 0);
            result = 31 * result + (this.rendererType != null ? this.rendererType.hashCode() : 0);
            result = 31 * result + (this.renderable ? 1 : 0);
            result = 31 * result + this.screenCount;
            return result;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.id).append("name", (Object)this.name).append("descriptionHtml", (Object)this.descriptionHtml).append("required", this.required).append("rendererType", (Object)this.rendererType).append("renderable", this.renderable).append("screensCount", this.screenCount).toString();
        }

        public boolean isLocked() {
            return this.locked;
        }

        public boolean isManaged() {
            return this.managed;
        }
    }

    public static class SimpleFieldConfig
    implements NamedDefault {
        private Long id;
        private String name;
        private String description;
        private String url;
        private boolean defaultFieldConfig;
        private Collection<Project> sharedProjects;
        private List<SimpleIssueType> issueTypes;
        private List<SimpleFieldLayoutItem> fieldLayoutItems;

        public static SimpleFieldConfig getSystemDefaultSimpleFieldConfig(String url, boolean defaultFieldconfig, Collection<Project> sharedProjects, List<SimpleFieldLayoutItem> fieldLayoutItems, List<SimpleIssueType> issueTypes) {
            return new SimpleFieldConfig(null, "Default Field Configuration", "The default field configuration", url, defaultFieldconfig, sharedProjects, fieldLayoutItems, issueTypes);
        }

        public SimpleFieldConfig(FieldLayout fieldLayout, String url, boolean defaultFieldConfig, Collection<Project> sharedProjects, List<SimpleFieldLayoutItem> fieldLayoutItems, List<SimpleIssueType> issueTypes) {
            this.id = fieldLayout.getId();
            this.name = fieldLayout.getName();
            this.description = fieldLayout.getDescription();
            this.url = url;
            this.defaultFieldConfig = defaultFieldConfig;
            this.sharedProjects = sharedProjects;
            this.fieldLayoutItems = fieldLayoutItems;
            this.issueTypes = issueTypes;
        }

        SimpleFieldConfig(Long id, String name, String description, String url, boolean defaultFieldConfig, Collection<Project> sharedProjects, List<SimpleFieldLayoutItem> fieldLayoutItems, List<SimpleIssueType> issueTypes) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.url = url;
            this.defaultFieldConfig = defaultFieldConfig;
            this.sharedProjects = sharedProjects;
            this.fieldLayoutItems = fieldLayoutItems;
            this.issueTypes = issueTypes;
        }

        public Long getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefaultFieldConfig();
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isDefaultFieldConfig() {
            return this.defaultFieldConfig;
        }

        public Collection<Project> getSharedProjects() {
            return this.sharedProjects;
        }

        public List<SimpleFieldLayoutItem> getFieldLayoutItems() {
            return this.fieldLayoutItems;
        }

        public Collection<SimpleIssueType> getIssueTypes() {
            return this.issueTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleFieldConfig that = (SimpleFieldConfig)o;
            if (this.defaultFieldConfig != that.defaultFieldConfig) {
                return false;
            }
            if (this.fieldLayoutItems != null ? !this.fieldLayoutItems.equals(that.fieldLayoutItems) : that.fieldLayoutItems != null) {
                return false;
            }
            if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
                return false;
            }
            if (this.issueTypes != null ? !this.issueTypes.equals(that.issueTypes) : that.issueTypes != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
                return false;
            }
            if (this.sharedProjects != null ? !this.sharedProjects.equals(that.sharedProjects) : that.sharedProjects != null) {
                return false;
            }
            return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
        }

        public int hashCode() {
            int result = this.id != null ? this.id.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
            result = 31 * result + (this.defaultFieldConfig ? 1 : 0);
            result = 31 * result + (this.sharedProjects != null ? this.sharedProjects.hashCode() : 0);
            result = 31 * result + (this.issueTypes != null ? this.issueTypes.hashCode() : 0);
            result = 31 * result + (this.fieldLayoutItems != null ? this.fieldLayoutItems.hashCode() : 0);
            return result;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.id).append("name", (Object)this.name).append("description", (Object)this.description).append("url", (Object)this.url).append("defaultFieldConfig", this.defaultFieldConfig).append("sharedProjects", this.sharedProjects).append("issueTypes", this.issueTypes).append("fieldLayoutItems", this.fieldLayoutItems).toString();
        }
    }
}

