/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.util.TabUrlFactory;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginParseException;
import java.util.Collection;
import java.util.Map;

public class PrioritiesSummaryPanelContextProvider
implements CacheableContextProvider {
    static final String CONTEXT_PRIORITIES_KEY = "priorities";
    static final String CONTEXT_PRIORITY_SCHEME_KEY = "priorityScheme";
    static final String MANAGE_URL = "manageUrl";
    private final PrioritySchemeManager prioritySchemeManager;
    private final TabUrlFactory tabUrlFactory;

    public PrioritiesSummaryPanelContextProvider(PrioritySchemeManager prioritySchemeManager, TabUrlFactory tabUrlFactory) {
        this.prioritySchemeManager = prioritySchemeManager;
        this.tabUrlFactory = tabUrlFactory;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Project project = (Project)context.get("project");
        FieldConfigScheme priorityScheme = this.prioritySchemeManager.getScheme(project);
        Collection<Priority> priorities = this.getPriorities(priorityScheme);
        return MapBuilder.newBuilder().addAll(context).add((Object)CONTEXT_PRIORITY_SCHEME_KEY, (Object)priorityScheme).add((Object)CONTEXT_PRIORITIES_KEY, priorities).add((Object)MANAGE_URL, (Object)this.tabUrlFactory.forPriorities()).toMap();
    }

    private Collection<Priority> getPriorities(FieldConfigScheme priorityScheme) {
        FieldConfig config = this.prioritySchemeManager.getFieldConfigForDefaultMapping(priorityScheme);
        return this.prioritySchemeManager.getPrioritiesFromIds((Collection)this.prioritySchemeManager.getOptions(config));
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return this.getClass().getName() + context.get("projectKeyEncoded");
    }
}

