/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderUtils;
import com.atlassian.jira.projectconfig.util.TabUrlFactory;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginParseException;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class PermissionsSummaryPanelContextProvider
implements CacheableContextProvider {
    private static final String PROJECT_PERMISSIONS_SCHEME = "projectPermissionsScheme";
    private static final String PROJECT_PERMISSION_URL = "projectPermissionUrl";
    private static final String ISSUE_SECURITY_SCHEME = "issueSecurityScheme";
    private static final String ISSUE_SECURITY_SCHEME_URL = "issueSecuritySchemeUrl";
    private final ContextProviderUtils providerUtils;
    private final PermissionSchemeManager permissionSchemeManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final TabUrlFactory tabUrlFactory;

    public PermissionsSummaryPanelContextProvider(PermissionSchemeManager permissionSchemeManager, IssueSecuritySchemeManager issueSecuritySchemeManager, ContextProviderUtils providerUtils, TabUrlFactory tabUrlFactory) {
        this.permissionSchemeManager = permissionSchemeManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.providerUtils = providerUtils;
        this.tabUrlFactory = tabUrlFactory;
    }

    public void init(Map<String, String> context) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        MapBuilder contextMap = MapBuilder.newBuilder().addAll(context);
        GenericValue projectGV = this.providerUtils.getProject().getGenericValue();
        GenericValue issueSecuritySchemeGv = this.getIssueSecuritySchemes(projectGV);
        if (issueSecuritySchemeGv != null) {
            SimpleIssueSecurityScheme issueSecuritySchemeBean = this.gvToIssueSecurityScheme(issueSecuritySchemeGv);
            contextMap.add((Object)ISSUE_SECURITY_SCHEME, (Object)issueSecuritySchemeBean);
        }
        contextMap.add((Object)ISSUE_SECURITY_SCHEME_URL, (Object)this.tabUrlFactory.forIssueSecurity());
        GenericValue projectPermissionsSchemeGV = this.getProjectPermissionsScheme(projectGV);
        if (projectPermissionsSchemeGV != null) {
            SimpleProjectPermissionsScheme projectPermissionsSchemeBean = this.gvToProjectPermissionsScheme(projectPermissionsSchemeGV);
            contextMap.add((Object)PROJECT_PERMISSIONS_SCHEME, (Object)projectPermissionsSchemeBean);
        }
        contextMap.add((Object)PROJECT_PERMISSION_URL, (Object)this.tabUrlFactory.forPermissions());
        return contextMap.toMap();
    }

    private UrlBuilder createUrlBuilder(String operation) {
        return this.providerUtils.createUrlBuilder(operation);
    }

    GenericValue getProjectPermissionsScheme(GenericValue projectGV) {
        try {
            return EntityUtil.getOnly((List)this.permissionSchemeManager.getSchemes(projectGV));
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
    }

    GenericValue getIssueSecuritySchemes(GenericValue projectGV) {
        try {
            return EntityUtil.getOnly((List)this.issueSecuritySchemeManager.getSchemes(projectGV));
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
    }

    SimpleProjectPermissionsScheme gvToProjectPermissionsScheme(GenericValue projectPermssionsGV) {
        return new SimpleProjectPermissionsScheme(projectPermssionsGV.getString("id"), projectPermssionsGV.getString("description"), projectPermssionsGV.getString("name"));
    }

    SimpleIssueSecurityScheme gvToIssueSecurityScheme(GenericValue issueSecurityGV) {
        return new SimpleIssueSecurityScheme(issueSecurityGV.getString("id"), issueSecurityGV.getString("description"), issueSecurityGV.getString("name"));
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return this.getClass().getName();
    }

    public static class SimpleIssueSecurityScheme {
        private final String id;
        private final String description;
        private final String name;

        SimpleIssueSecurityScheme(String id, String description, String name) {
            this.id = id;
            this.description = description;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class SimpleProjectPermissionsScheme {
        private final String id;
        private final String description;
        private final String name;

        SimpleProjectPermissionsScheme(String id, String description, String name) {
            this.id = id;
            this.description = description;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }
    }
}

