/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.beans.SimpleIssueType;
import com.atlassian.jira.projectconfig.beans.SimpleIssueTypeImpl;
import com.atlassian.jira.projectconfig.order.OrderFactory;
import com.atlassian.jira.projectconfig.util.TabUrlFactory;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginParseException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class IssueTypesSummaryPanelContextProvider
implements CacheableContextProvider {
    static final String CONTEXT_ISSUE_TYPES_KEY = "issueTypes";
    static final String CONTEXT_ISSUE_TYPE_SCHEME_KEY = "issueTypeScheme";
    static final String CONTEXT_ERRORS_KEY = "errors";
    static final String ISSUE_TYPE_SCHEME_ERROR_I18N_KEY = "admin.project.config.summary.issuetypes.no.issuetypescheme.error";
    static final String MANAGE_URL = "manageUrl";
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final TabUrlFactory tabUrlFactory;
    private final OrderFactory orderFactory;

    public IssueTypesSummaryPanelContextProvider(IssueTypeSchemeManager issueTypeSchemeManager, TabUrlFactory tabUrlFactory, OrderFactory orderFactory) {
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.tabUrlFactory = tabUrlFactory;
        this.orderFactory = orderFactory;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Project project = (Project)context.get("project");
        I18nHelper i18nHelper = (I18nHelper)context.get("i18n");
        Collection<SimpleIssueType> simpleIssueTypes = this.getSimpleIssueTypes(project);
        FieldConfigScheme issueTypeScheme = this.issueTypeSchemeManager.getConfigScheme(project);
        ArrayList errors = Lists.newArrayList();
        if (issueTypeScheme == null) {
            errors.add(i18nHelper.getText(ISSUE_TYPE_SCHEME_ERROR_I18N_KEY));
        }
        return MapBuilder.newBuilder().addAll(context).add((Object)CONTEXT_ISSUE_TYPES_KEY, simpleIssueTypes).add((Object)CONTEXT_ISSUE_TYPE_SCHEME_KEY, (Object)issueTypeScheme).add((Object)CONTEXT_ERRORS_KEY, (Object)errors).add((Object)MANAGE_URL, (Object)this.tabUrlFactory.forIssueTypes()).toMap();
    }

    private Collection<SimpleIssueType> getSimpleIssueTypes(Project project) {
        ArrayList issueTypes = new ArrayList(this.issueTypeSchemeManager.getIssueTypesForProject(project));
        Collections.sort(issueTypes, (i1, i2) -> i1.getName().compareToIgnoreCase(i2.getName()));
        IssueType defaultIssueType = this.issueTypeSchemeManager.getDefaultIssueType(project);
        ArrayList simpleIssueTypes = Lists.newArrayList();
        for (IssueType issueType : issueTypes) {
            if (defaultIssueType != null && defaultIssueType.equals(issueType)) {
                simpleIssueTypes.add(new SimpleIssueTypeImpl(issueType, true));
                continue;
            }
            simpleIssueTypes.add(new SimpleIssueTypeImpl(issueType, false));
        }
        return simpleIssueTypes;
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return this.getClass().getName();
    }
}

