/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderHelper;
import com.atlassian.jira.projectconfig.order.OrderFactory;
import com.atlassian.jira.projectconfig.util.ProjectConfigRequestCache;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContextProviderUtils {
    static final String CONTEXT_PROJECT_KEY = "project";
    static final String CONTEXT_IS_ADMIN_KEY = "isAdmin";
    static final String CONTEXT_IS_PROJECT_ADMIN_KEY = "isProjectAdmin";
    static final String CONTEXT_I18N_KEY = "i18n";
    static final String CONTEXT_PROJECT_KEY_ENCODED = "projectKeyEncoded";
    private final ProjectConfigRequestCache cache;
    private final OrderFactory orderFactory;
    private final ContextProviderHelper contextProviderHelper;

    @Autowired
    public ContextProviderUtils(ProjectConfigRequestCache cache, OrderFactory orderFactory, ContextProviderHelper contextProviderHelper) {
        this.cache = cache;
        this.orderFactory = orderFactory;
        this.contextProviderHelper = contextProviderHelper;
    }

    public Project getProject() {
        return this.cache.getProject();
    }

    public Comparator<String> getStringComparator() {
        return this.orderFactory.createStringComparator();
    }

    public Map<String, Object> getDefaultContext() {
        Project project = this.getProject();
        return MapBuilder.newBuilder().add((Object)CONTEXT_PROJECT_KEY, (Object)project).add((Object)CONTEXT_PROJECT_KEY_ENCODED, (Object)this.contextProviderHelper.encode(project.getKey())).add((Object)CONTEXT_IS_ADMIN_KEY, (Object)this.contextProviderHelper.hasAdminPermission()).add((Object)CONTEXT_IS_PROJECT_ADMIN_KEY, (Object)this.contextProviderHelper.hasProjectAdminPermission(this.getProject())).add((Object)CONTEXT_I18N_KEY, (Object)this.contextProviderHelper.getI18nHelper()).toMap();
    }

    public Set<String> flattenErrors(ErrorCollection collection) {
        Assertions.notNull((String)"collection", (Object)collection);
        LinkedHashSet<String> errors = new LinkedHashSet<String>();
        errors.addAll(collection.getErrorMessages());
        errors.addAll(collection.getErrors().values());
        return errors;
    }

    public String getBaseUrl() {
        return this.contextProviderHelper.getBaseUrl();
    }

    public UrlBuilder createUrlBuilder(String basename) {
        return this.contextProviderHelper.createUrlBuilder(basename);
    }
}

