/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.contextproviders;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.projectconfig.contextproviders.ContextProviderUtils;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginParseException;
import java.util.Map;

public class ComponentsContextProvider
implements CacheableContextProvider {
    private final ContextProviderUtils utils;
    private final UserManager userManager;
    private final UserPickerSearchService userPickerSearchService;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public ComponentsContextProvider(ContextProviderUtils utils, UserManager userManager, UserPickerSearchService userPickerSearchService, JiraAuthenticationContext jiraAuthenticationContext) {
        this.utils = utils;
        this.userManager = userManager;
        this.userPickerSearchService = userPickerSearchService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public void init(Map<String, String> stringStringMap) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> params) {
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(this.jiraAuthenticationContext.getLoggedInUser(), (ErrorCollection)new SimpleErrorCollection());
        return MapBuilder.newBuilder(params).add((Object)"isUserPickerDisabled", (Object)(!this.userPickerSearchService.canPerformAjaxSearch((JiraServiceContext)jiraServiceContext) ? 1 : 0)).add((Object)"projectLeadAssignee", (Object)this.getProjectLeadAssigneeDisplayName()).add((Object)"isDefaultAssigneeProjectLead", (Object)this.isDefaultAssigneeProjectLead()).toMap();
    }

    private String getProjectLeadAssigneeDisplayName() {
        String leadUser = this.utils.getProject().getLeadUserName();
        ApplicationUser user = this.userManager.getUserEvenWhenUnknown(leadUser);
        return user.getDisplayName();
    }

    private boolean isDefaultAssigneeProjectLead() {
        return this.utils.getProject().getAssigneeType() == null || this.utils.getProject().getAssigneeType() == 2L;
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return this.getClass().getName();
    }
}

